/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.nodejs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.commons.lang.SystemUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.nodejs.NodeCommandBuilder;
import org.sonarsource.nodejs.NodeCommandBuilderImpl;
import org.sonarsource.nodejs.NodeCommandException;
import org.sonarsource.nodejs.StreamConsumer;

public class NodeCommand {
    private static final Logger LOG = Loggers.get(NodeCommand.class);
    final Consumer<String> outputConsumer;
    final Consumer<String> errorConsumer;
    private final StreamConsumer streamConsumer;
    private final ProcessWrapper processWrapper;
    private Process process;
    private final List<String> command;

    NodeCommand(ProcessWrapper processWrapper, String nodeExecutable, List<String> nodeJsArgs, @Nullable String scriptFilename, List<String> args, Consumer<String> outputConsumer, Consumer<String> errorConsumer) {
        this.processWrapper = processWrapper;
        this.command = this.buildCommand(nodeExecutable, nodeJsArgs, scriptFilename, args);
        this.outputConsumer = outputConsumer;
        this.errorConsumer = errorConsumer;
        this.streamConsumer = new StreamConsumer();
    }

    public void start() {
        try {
            LOG.debug("Launching command {}", this.command);
            this.process = this.processWrapper.start(this.command);
            this.streamConsumer.consumeStream(this.process.getInputStream(), this.outputConsumer);
            this.streamConsumer.consumeStream(this.process.getErrorStream(), this.errorConsumer);
        }
        catch (IOException e) {
            throw new NodeCommandException("Error when running: '" + this.toString() + "'. Is Node.js available during analysis?", e);
        }
    }

    private List<String> buildCommand(String nodeExecutable, List<String> nodeJsArgs, @Nullable String scriptFilename, List<String> args) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(nodeExecutable);
        result.addAll(nodeJsArgs);
        if (scriptFilename != null) {
            result.add(scriptFilename);
        }
        result.addAll(args);
        if (this.processWrapper.isMac()) {
            return Arrays.asList("/bin/sh", "-c", String.join((CharSequence)" ", result));
        }
        return Collections.unmodifiableList(result);
    }

    public int waitFor() {
        try {
            int exitValue = this.processWrapper.waitFor(this.process);
            this.streamConsumer.await();
            int n = exitValue;
            return n;
        }
        catch (InterruptedException e) {
            this.processWrapper.interrupt();
            LOG.error("Interrupted while waiting for process to terminate.");
            int n = 1;
            return n;
        }
        finally {
            this.streamConsumer.shutdownNow();
        }
    }

    public void destroy() {
        this.processWrapper.destroy(this.process);
        this.streamConsumer.shutdownNow();
    }

    public String toString() {
        return String.join((CharSequence)" ", this.command);
    }

    public static NodeCommandBuilder builder() {
        return NodeCommand.builder(new ProcessWrapperImpl());
    }

    static NodeCommandBuilder builder(ProcessWrapper processWrapper) {
        return new NodeCommandBuilderImpl(processWrapper);
    }

    private static class ProcessWrapperImpl
    implements ProcessWrapper {
        private ProcessWrapperImpl() {
        }

        @Override
        public Process start(List<String> commandLine) throws IOException {
            ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
            return processBuilder.start();
        }

        @Override
        public int waitFor(Process process) throws InterruptedException {
            return process.waitFor();
        }

        @Override
        public void interrupt() {
            Thread.currentThread().interrupt();
        }

        @Override
        public void destroy(Process process) {
            process.destroy();
        }

        @Override
        public boolean isMac() {
            return SystemUtils.IS_OS_MAC;
        }
    }

    static interface ProcessWrapper {
        public Process start(List<String> var1) throws IOException;

        public int waitFor(Process var1) throws InterruptedException;

        public void interrupt();

        public void destroy(Process var1);

        public boolean isMac();
    }
}

