/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.nodejs;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.SystemUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.nodejs.NodeCommandBuilder;
import org.sonarsource.nodejs.NodeCommandBuilderImpl;
import org.sonarsource.nodejs.NodeCommandException;
import org.sonarsource.nodejs.StreamConsumer;

public class NodeCommand {
    private static final Logger LOG = Loggers.get(NodeCommand.class);
    final Consumer<String> outputConsumer;
    final Consumer<String> errorConsumer;
    private final StreamConsumer streamConsumer;
    private final ProcessWrapper processWrapper;
    private final List<Path> nodePath;
    private Process process;
    private final List<String> command;

    NodeCommand(ProcessWrapper processWrapper, String nodeExecutable, List<Path> nodePath, List<String> nodeJsArgs, @Nullable String scriptFilename, List<String> args, Consumer<String> outputConsumer, Consumer<String> errorConsumer) {
        this.processWrapper = processWrapper;
        this.command = NodeCommand.buildCommand(nodeExecutable, nodeJsArgs, scriptFilename, args);
        this.nodePath = nodePath;
        this.outputConsumer = outputConsumer;
        this.errorConsumer = errorConsumer;
        this.streamConsumer = new StreamConsumer();
    }

    public void start() {
        try {
            LOG.debug("Launching command {}", (Object)this.toString());
            this.process = this.processWrapper.start(this.command, this.envWithNodePath());
            this.streamConsumer.consumeStream(this.process.getInputStream(), this.outputConsumer);
            this.streamConsumer.consumeStream(this.process.getErrorStream(), this.errorConsumer);
        }
        catch (IOException e) {
            throw new NodeCommandException("Error when running: '" + this.toString() + "'. Is Node.js available during analysis?", e);
        }
    }

    private Map<String, String> envWithNodePath() {
        HashMap<String, String> env = new HashMap<String, String>();
        if (this.nodePath.isEmpty()) {
            return env;
        }
        String nodePathString = this.nodePath.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator));
        String currentNodePath = this.processWrapper.getenv("NODE_PATH");
        String newNodePath = currentNodePath == null ? nodePathString : currentNodePath + File.pathSeparator + nodePathString;
        env.put("NODE_PATH", newNodePath);
        return env;
    }

    private static List<String> buildCommand(String nodeExecutable, List<String> nodeJsArgs, @Nullable String scriptFilename, List<String> args) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(nodeExecutable);
        result.addAll(nodeJsArgs);
        if (scriptFilename != null) {
            result.add(scriptFilename);
        }
        result.addAll(args);
        return result;
    }

    public int waitFor() {
        try {
            int exitValue = this.processWrapper.waitFor(this.process);
            this.streamConsumer.await();
            int n = exitValue;
            return n;
        }
        catch (InterruptedException e) {
            this.processWrapper.interrupt();
            LOG.error("Interrupted while waiting for process to terminate.");
            int n = 1;
            return n;
        }
        finally {
            this.streamConsumer.shutdownNow();
        }
    }

    public void destroy() {
        this.processWrapper.destroy(this.process);
        this.streamConsumer.shutdownNow();
    }

    public String toString() {
        String commandString = String.join((CharSequence)" ", this.command);
        Map<String, String> env = this.envWithNodePath();
        if (env.isEmpty()) {
            return commandString;
        }
        return env + " " + commandString;
    }

    public static NodeCommandBuilder builder() {
        return NodeCommand.builder(new ProcessWrapperImpl());
    }

    static NodeCommandBuilder builder(ProcessWrapper processWrapper) {
        return new NodeCommandBuilderImpl(processWrapper);
    }

    private static class ProcessWrapperImpl
    implements ProcessWrapper {
        private ProcessWrapperImpl() {
        }

        @Override
        public Process start(List<String> commandLine, Map<String, String> env) throws IOException {
            ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
            processBuilder.environment().putAll(env);
            return processBuilder.start();
        }

        @Override
        public int waitFor(Process process) throws InterruptedException {
            return process.waitFor();
        }

        @Override
        public void interrupt() {
            Thread.currentThread().interrupt();
        }

        @Override
        public void destroy(Process process) {
            process.destroy();
        }

        @Override
        public boolean isMac() {
            return SystemUtils.IS_OS_MAC;
        }

        @Override
        @CheckForNull
        public String getenv(String name) {
            return System.getenv(name);
        }
    }

    static interface ProcessWrapper {
        public Process start(List<String> var1, Map<String, String> var2) throws IOException;

        public int waitFor(Process var1) throws InterruptedException;

        public void interrupt();

        public void destroy(Process var1);

        public boolean isMac();

        @CheckForNull
        public String getenv(String var1);
    }
}

