/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.nodejs;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;
import org.sonar.api.internal.google.common.annotations.VisibleForTesting;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.nodejs.BundlePathResolver;
import org.sonarsource.nodejs.NodeCommand;
import org.sonarsource.nodejs.NodeCommandBuilder;
import org.sonarsource.nodejs.NodeCommandException;

class NodeCommandBuilderImpl
implements NodeCommandBuilder {
    private static final Logger LOG = Loggers.get(NodeCommandBuilderImpl.class);
    public static final String NODE_EXECUTABLE_DEFAULT = "node";
    private static final String NODE_EXECUTABLE_DEFAULT_MACOS = "package/node_modules/run-node/run-node";
    private static final String NODE_EXECUTABLE_PROPERTY = "sonar.nodejs.executable";
    private static final String NODE_EXECUTABLE_PROPERTY_TS = "sonar.typescript.node";
    private static final Pattern NODEJS_VERSION_PATTERN = Pattern.compile("v?(\\d+)\\.\\d+\\.\\d+");
    private final NodeCommand.ProcessWrapper processWrapper;
    private Integer minNodeVersion;
    private Configuration configuration;
    private List<String> args = new ArrayList<String>();
    private List<String> nodeJsArgs = new ArrayList<String>();
    private Consumer<String> outputConsumer = arg_0 -> ((Logger)LOG).info(arg_0);
    private Consumer<String> errorConsumer = arg_0 -> ((Logger)LOG).error(arg_0);
    private String scriptFilename;
    private List<Path> nodePath = new ArrayList<Path>();
    private BundlePathResolver pathResolver;

    NodeCommandBuilderImpl(NodeCommand.ProcessWrapper processWrapper) {
        this.processWrapper = processWrapper;
    }

    @Override
    public NodeCommandBuilder minNodeVersion(int minNodeVersion) {
        this.minNodeVersion = minNodeVersion;
        return this;
    }

    @Override
    public NodeCommandBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    @Override
    public NodeCommandBuilder addToNodePath(Path path) {
        if (path == null) {
            throw new IllegalArgumentException("Node path can't be null");
        }
        this.nodePath.add(path);
        return this;
    }

    @Override
    public NodeCommandBuilder maxOldSpaceSize(int maxOldSpaceSize) {
        this.nodeJsArgs("--max-old-space-size=" + maxOldSpaceSize);
        return this;
    }

    @Override
    public NodeCommandBuilder nodeJsArgs(String ... nodeJsArgs) {
        this.nodeJsArgs.addAll(Arrays.asList(nodeJsArgs));
        return this;
    }

    @Override
    public NodeCommandBuilder script(String scriptFilename) {
        this.scriptFilename = scriptFilename;
        return this;
    }

    @Override
    public NodeCommandBuilder scriptArgs(String ... args) {
        this.args.addAll(Arrays.asList(args));
        return this;
    }

    @Override
    public NodeCommandBuilder outputConsumer(Consumer<String> consumer) {
        this.outputConsumer = consumer;
        return this;
    }

    @Override
    public NodeCommandBuilder errorConsumer(Consumer<String> consumer) {
        this.errorConsumer = consumer;
        return this;
    }

    @Override
    public NodeCommandBuilder pathResolver(BundlePathResolver pathResolver) {
        this.pathResolver = pathResolver;
        return this;
    }

    @Override
    public NodeCommand build() throws NodeCommandException, IOException {
        String nodeExecutable = this.retrieveNodeExecutableFromConfig(this.configuration);
        this.checkNodeCompatibility(nodeExecutable);
        if (this.nodeJsArgs.isEmpty() && this.scriptFilename == null && this.args.isEmpty()) {
            throw new IllegalArgumentException("Missing arguments for Node.js.");
        }
        if (this.scriptFilename == null && !this.args.isEmpty()) {
            throw new IllegalArgumentException("No script provided, but script arguments found.");
        }
        return new NodeCommand(this.processWrapper, nodeExecutable, this.nodePath, this.nodeJsArgs, this.scriptFilename, this.args, this.outputConsumer, this.errorConsumer);
    }

    private void checkNodeCompatibility(String nodeExecutable) throws NodeCommandException {
        if (this.minNodeVersion == null) {
            return;
        }
        LOG.debug("Checking Node.js version");
        String actualVersion = this.getVersion(nodeExecutable);
        boolean isCompatible = NodeCommandBuilderImpl.checkVersion(actualVersion, this.minNodeVersion);
        if (!isCompatible) {
            throw new NodeCommandException(String.format("Only Node.js v%s or later is supported, got %s.", this.minNodeVersion, actualVersion));
        }
        LOG.debug("Using Node.js {}.", (Object)actualVersion);
    }

    @VisibleForTesting
    static boolean checkVersion(String actualVersion, int requiredVersion) throws NodeCommandException {
        Matcher versionMatcher = NODEJS_VERSION_PATTERN.matcher(actualVersion);
        if (versionMatcher.lookingAt()) {
            int major = Integer.parseInt(versionMatcher.group(1));
            return major >= requiredVersion;
        }
        throw new NodeCommandException("Failed to parse Node.js version, got '" + actualVersion + "'");
    }

    private String getVersion(String nodeExecutable) throws NodeCommandException {
        StringBuilder output = new StringBuilder();
        NodeCommand nodeCommand = new NodeCommand(this.processWrapper, nodeExecutable, Collections.emptyList(), Collections.singletonList("-v"), null, Collections.emptyList(), output::append, arg_0 -> ((Logger)LOG).error(arg_0));
        nodeCommand.start();
        int exitValue = nodeCommand.waitFor();
        if (exitValue != 0) {
            throw new NodeCommandException("Failed to determine the version of Node.js, exit value " + exitValue + ". Executed: '" + nodeCommand.toString() + "'");
        }
        return output.toString();
    }

    private String retrieveNodeExecutableFromConfig(@Nullable Configuration configuration) throws NodeCommandException, IOException {
        if (configuration != null && (configuration.hasKey(NODE_EXECUTABLE_PROPERTY) || configuration.hasKey(NODE_EXECUTABLE_PROPERTY_TS))) {
            File file;
            String nodeExecutable = "";
            String usedProperty = "";
            if (configuration.hasKey(NODE_EXECUTABLE_PROPERTY_TS)) {
                LOG.warn("The use of sonar.typescript.node is deprecated, use sonar.nodejs.executable instead.");
                usedProperty = NODE_EXECUTABLE_PROPERTY_TS;
                nodeExecutable = (String)configuration.get(NODE_EXECUTABLE_PROPERTY_TS).get();
            }
            if (configuration.hasKey(NODE_EXECUTABLE_PROPERTY)) {
                usedProperty = NODE_EXECUTABLE_PROPERTY;
                nodeExecutable = (String)configuration.get(NODE_EXECUTABLE_PROPERTY).get();
            }
            if ((file = new File(nodeExecutable)).exists()) {
                LOG.info("Using Node.js executable {} from property {}.", (Object)file.getAbsoluteFile(), (Object)usedProperty);
                return nodeExecutable;
            }
            LOG.error("Provided Node.js executable file does not exist. Property '{}' was to '{}'", (Object)usedProperty, (Object)nodeExecutable);
            throw new NodeCommandException("Provided Node.js executable file does not exist.");
        }
        String defaultNode = NODE_EXECUTABLE_DEFAULT;
        if (this.processWrapper.isMac()) {
            defaultNode = this.pathResolver.resolve(NODE_EXECUTABLE_DEFAULT_MACOS);
            File file = new File(defaultNode);
            if (!file.exists()) {
                LOG.error("Default Node.js executable for MacOS does not exist. Value '{}'. Consider setting Node.js location through property '{}'", (Object)defaultNode, (Object)NODE_EXECUTABLE_PROPERTY);
                throw new NodeCommandException("Default Node.js executable for MacOS does not exist.");
            }
            Files.setPosixFilePermissions(file.toPath(), EnumSet.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_READ));
        }
        LOG.debug("Using default Node.js executable: '{}'.", (Object)defaultNode);
        return defaultNode;
    }
}

