/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.nodejs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.SystemUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.nodejs.NodeCommandBuilder;
import org.sonarsource.nodejs.NodeCommandBuilderImpl;
import org.sonarsource.nodejs.NodeCommandException;
import org.sonarsource.nodejs.StreamConsumer;

public class NodeCommand {
    private static final Logger LOG = Loggers.get(NodeCommand.class);
    final Consumer<String> outputConsumer;
    final Consumer<String> errorConsumer;
    private final StreamConsumer streamConsumer;
    private final ProcessWrapper processWrapper;
    private final int actualNodeVersion;
    private Process process;
    private final List<String> command;

    NodeCommand(ProcessWrapper processWrapper, String nodeExecutable, int actualNodeVersion, List<String> nodeJsArgs, @Nullable String scriptFilename, List<String> args, Consumer<String> outputConsumer, Consumer<String> errorConsumer) {
        this.processWrapper = processWrapper;
        this.command = NodeCommand.buildCommand(nodeExecutable, nodeJsArgs, scriptFilename, args);
        this.actualNodeVersion = actualNodeVersion;
        this.outputConsumer = outputConsumer;
        this.errorConsumer = errorConsumer;
        this.streamConsumer = new StreamConsumer();
    }

    public void start() {
        try {
            LOG.debug("Launching command {}", (Object)this.toString());
            this.process = this.processWrapper.start(this.command, new HashMap<String, String>());
            this.streamConsumer.consumeStream(this.process.getInputStream(), this.outputConsumer);
            this.streamConsumer.consumeStream(this.process.getErrorStream(), this.errorConsumer);
        }
        catch (IOException e) {
            throw new NodeCommandException("Error when running: '" + this.toString() + "'. Is Node.js available during analysis?", e);
        }
    }

    private static List<String> buildCommand(String nodeExecutable, List<String> nodeJsArgs, @Nullable String scriptFilename, List<String> args) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(nodeExecutable);
        result.addAll(nodeJsArgs);
        if (scriptFilename != null) {
            result.add(scriptFilename);
        }
        result.addAll(args);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitFor() {
        try {
            int exitValue;
            boolean success = this.processWrapper.waitFor(this.process, 1L, TimeUnit.MINUTES);
            if (success) {
                exitValue = this.processWrapper.exitValue(this.process);
            } else {
                LOG.error("Node process did not stop in a timely fashion");
                this.processWrapper.destroyForcibly(this.process);
                exitValue = -1;
            }
            this.streamConsumer.await();
            int n = exitValue;
            return n;
        }
        catch (InterruptedException e) {
            this.processWrapper.interrupt();
            LOG.error("Interrupted while waiting for process to terminate.");
            int n = 1;
            return n;
        }
        finally {
            this.streamConsumer.shutdownNow();
        }
    }

    public String toString() {
        return String.join((CharSequence)" ", this.command);
    }

    public int getActualNodeVersion() {
        return this.actualNodeVersion;
    }

    public static NodeCommandBuilder builder() {
        return NodeCommand.builder(new ProcessWrapperImpl());
    }

    static NodeCommandBuilder builder(ProcessWrapper processWrapper) {
        return new NodeCommandBuilderImpl(processWrapper);
    }

    private static class ProcessWrapperImpl
    implements ProcessWrapper {
        private ProcessWrapperImpl() {
        }

        @Override
        public Process start(List<String> commandLine, Map<String, String> env) throws IOException {
            ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
            processBuilder.environment().putAll(env);
            return processBuilder.start();
        }

        @Override
        public boolean waitFor(Process process, long timeout, TimeUnit unit) throws InterruptedException {
            return process.waitFor(timeout, unit);
        }

        @Override
        public void interrupt() {
            Thread.currentThread().interrupt();
        }

        @Override
        public void destroyForcibly(Process process) {
            process.destroyForcibly();
        }

        @Override
        public boolean isMac() {
            return SystemUtils.IS_OS_MAC;
        }

        @Override
        @CheckForNull
        public String getenv(String name) {
            return System.getenv(name);
        }

        @Override
        public int exitValue(Process process) {
            return process.exitValue();
        }
    }

    static interface ProcessWrapper {
        public Process start(List<String> var1, Map<String, String> var2) throws IOException;

        public boolean waitFor(Process var1, long var2, TimeUnit var4) throws InterruptedException;

        public void interrupt();

        public void destroyForcibly(Process var1);

        public boolean isMac();

        @CheckForNull
        public String getenv(String var1);

        public int exitValue(Process var1);
    }
}

