/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.nodejs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

class StreamConsumer {
    private static final Logger LOG = Loggers.get(StreamConsumer.class);
    private final ExecutorService executorService = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r);
        thread.setName("nodejs-stream-consumer");
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler((t, e) -> LOG.error("Error in thread " + t.getName(), e));
        return thread;
    });

    StreamConsumer() {
    }

    void consumeStream(InputStream inputStream, Consumer<String> consumer) {
        this.executorService.submit(() -> {
            try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                errorReader.lines().forEach(consumer);
            }
            catch (IOException e) {
                LOG.error("Error while reading stream", (Throwable)e);
            }
        });
    }

    void await() throws InterruptedException {
        this.executorService.shutdown();
        if (!this.executorService.awaitTermination(5L, TimeUnit.MINUTES)) {
            LOG.error("External process stream consumer timed out");
            this.executorService.shutdownNow();
        }
    }

    boolean isShutdown() {
        return this.executorService.isShutdown();
    }
}

