/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.nodejs;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.Version;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.nodejs.BundlePathResolver;
import org.sonarsource.nodejs.NodeCommand;
import org.sonarsource.nodejs.NodeCommandBuilder;
import org.sonarsource.nodejs.NodeCommandException;
import org.sonarsource.nodejs.ProcessWrapper;

public class NodeCommandBuilderImpl
implements NodeCommandBuilder {
    private static final Logger LOG = Loggers.get(NodeCommandBuilderImpl.class);
    public static final String NODE_EXECUTABLE_DEFAULT = "node";
    private static final String NODE_EXECUTABLE_DEFAULT_MACOS = "package/node_modules/run-node/run-node";
    private static final String NODE_EXECUTABLE_PROPERTY = "sonar.nodejs.executable";
    private static final Pattern NODEJS_VERSION_PATTERN = Pattern.compile("v?(\\d+)\\.(\\d+)\\.(\\d+)");
    private final ProcessWrapper processWrapper;
    private Version minNodeVersion;
    private Configuration configuration;
    private List<String> args = new ArrayList<String>();
    private List<String> nodeJsArgs = new ArrayList<String>();
    private Consumer<String> outputConsumer = arg_0 -> ((Logger)LOG).info(arg_0);
    private Consumer<String> errorConsumer = arg_0 -> ((Logger)LOG).error(arg_0);
    private String scriptFilename;
    private BundlePathResolver pathResolver;
    private Version actualNodeVersion;
    private Map<String, String> env = Map.of();

    public NodeCommandBuilderImpl(ProcessWrapper processWrapper) {
        this.processWrapper = processWrapper;
    }

    @Override
    public NodeCommandBuilder minNodeVersion(Version minNodeVersion) {
        this.minNodeVersion = minNodeVersion;
        return this;
    }

    @Override
    public NodeCommandBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    @Override
    public NodeCommandBuilder maxOldSpaceSize(int maxOldSpaceSize) {
        this.nodeJsArgs("--max-old-space-size=" + maxOldSpaceSize);
        return this;
    }

    @Override
    public NodeCommandBuilder nodeJsArgs(String ... nodeJsArgs) {
        this.nodeJsArgs.addAll(Arrays.asList(nodeJsArgs));
        return this;
    }

    @Override
    public NodeCommandBuilder script(String scriptFilename) {
        this.scriptFilename = scriptFilename;
        return this;
    }

    @Override
    public NodeCommandBuilder scriptArgs(String ... args) {
        this.args.addAll(Arrays.asList(args));
        return this;
    }

    @Override
    public NodeCommandBuilder outputConsumer(Consumer<String> consumer) {
        this.outputConsumer = consumer;
        return this;
    }

    @Override
    public NodeCommandBuilder errorConsumer(Consumer<String> consumer) {
        this.errorConsumer = consumer;
        return this;
    }

    @Override
    public NodeCommandBuilder pathResolver(BundlePathResolver pathResolver) {
        this.pathResolver = pathResolver;
        return this;
    }

    @Override
    public NodeCommandBuilder env(Map<String, String> env) {
        this.env = Map.copyOf(env);
        return this;
    }

    @Override
    public NodeCommand build() throws NodeCommandException, IOException {
        String nodeExecutable = this.retrieveNodeExecutableFromConfig(this.configuration);
        this.checkNodeCompatibility(nodeExecutable);
        if (this.nodeJsArgs.isEmpty() && this.scriptFilename == null && this.args.isEmpty()) {
            throw new IllegalArgumentException("Missing arguments for Node.js.");
        }
        if (this.scriptFilename == null && !this.args.isEmpty()) {
            throw new IllegalArgumentException("No script provided, but script arguments found.");
        }
        return new NodeCommand(this.processWrapper, nodeExecutable, this.actualNodeVersion, this.nodeJsArgs, this.scriptFilename, this.args, this.outputConsumer, this.errorConsumer, this.env);
    }

    private void checkNodeCompatibility(String nodeExecutable) throws NodeCommandException {
        if (this.minNodeVersion == null) {
            return;
        }
        LOG.debug("Checking Node.js version");
        String versionString = this.getVersion(nodeExecutable);
        this.actualNodeVersion = NodeCommandBuilderImpl.nodeVersion(versionString);
        if (!this.actualNodeVersion.isGreaterThanOrEqual(this.minNodeVersion)) {
            throw new NodeCommandException(String.format("Only Node.js v%s or later is supported, got %s.", this.minNodeVersion, this.actualNodeVersion));
        }
        LOG.debug("Using Node.js {}.", (Object)versionString);
    }

    static Version nodeVersion(String versionString) throws NodeCommandException {
        Matcher versionMatcher = NODEJS_VERSION_PATTERN.matcher(versionString);
        if (versionMatcher.lookingAt()) {
            return Version.create((int)Integer.parseInt(versionMatcher.group(1)), (int)Integer.parseInt(versionMatcher.group(2)), (int)Integer.parseInt(versionMatcher.group(3)));
        }
        throw new NodeCommandException("Failed to parse Node.js version, got '" + versionString + "'");
    }

    private String getVersion(String nodeExecutable) throws NodeCommandException {
        StringBuilder output = new StringBuilder();
        NodeCommand nodeCommand = new NodeCommand(this.processWrapper, nodeExecutable, Version.create((int)0, (int)0), Collections.singletonList("-v"), null, Collections.emptyList(), output::append, arg_0 -> ((Logger)LOG).error(arg_0), Map.of());
        nodeCommand.start();
        int exitValue = nodeCommand.waitFor();
        if (exitValue != 0) {
            throw new NodeCommandException("Failed to determine the version of Node.js, exit value " + exitValue + ". Executed: '" + nodeCommand.toString() + "'");
        }
        return output.toString();
    }

    private String retrieveNodeExecutableFromConfig(@Nullable Configuration configuration) throws NodeCommandException, IOException {
        if (configuration != null && configuration.hasKey(NODE_EXECUTABLE_PROPERTY)) {
            String nodeExecutable = (String)configuration.get(NODE_EXECUTABLE_PROPERTY).get();
            File file = new File(nodeExecutable);
            if (file.exists()) {
                LOG.info("Using Node.js executable {} from property {}.", (Object)file.getAbsoluteFile(), (Object)NODE_EXECUTABLE_PROPERTY);
                return nodeExecutable;
            }
            LOG.error("Provided Node.js executable file does not exist. Property '{}' was set to '{}'", (Object)NODE_EXECUTABLE_PROPERTY, (Object)nodeExecutable);
            throw new NodeCommandException("Provided Node.js executable file does not exist.");
        }
        return this.locateNode();
    }

    private String locateNode() throws IOException {
        String defaultNode = NODE_EXECUTABLE_DEFAULT;
        if (this.processWrapper.isMac()) {
            defaultNode = this.locateNodeOnMac();
        } else if (this.processWrapper.isWindows()) {
            defaultNode = this.locateNodeOnWindows();
        }
        LOG.debug("Using default Node.js executable: '{}'.", (Object)defaultNode);
        return defaultNode;
    }

    private String locateNodeOnMac() throws IOException {
        LOG.debug("Looking for Node.js in the PATH using run-node (macOS)");
        String defaultNode = this.pathResolver.resolve(NODE_EXECUTABLE_DEFAULT_MACOS);
        File file = new File(defaultNode);
        if (!file.exists()) {
            LOG.error("Default Node.js executable for MacOS does not exist. Value '{}'. Consider setting Node.js location through property '{}'", (Object)defaultNode, (Object)NODE_EXECUTABLE_PROPERTY);
            throw new NodeCommandException("Default Node.js executable for MacOS does not exist.");
        }
        Files.setPosixFilePermissions(file.toPath(), EnumSet.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_READ));
        return defaultNode;
    }

    private String locateNodeOnWindows() throws IOException {
        LOG.debug("Looking for Node.js in the PATH using where.exe (Windows)");
        ArrayList stdOut = new ArrayList();
        Process whereTool = this.processWrapper.startProcess(Arrays.asList("C:\\Windows\\System32\\where.exe", "$PATH:node.exe"), Collections.emptyMap(), stdOut::add, arg_0 -> ((Logger)LOG).error(arg_0));
        try {
            this.processWrapper.waitFor(whereTool, 5L, TimeUnit.SECONDS);
            if (!stdOut.isEmpty()) {
                String out = (String)stdOut.get(0);
                LOG.debug("Found node.exe at {}", (Object)out);
                return out;
            }
        }
        catch (InterruptedException e) {
            this.processWrapper.interrupt();
            LOG.error("Interrupted while waiting for 'where.exe' to terminate.");
        }
        throw new NodeCommandException("Node.js not found in PATH. PATH value was: " + this.processWrapper.getenv("PATH"));
    }
}

