/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.cpd;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.Lexer;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import org.sonar.javascript.lexer.JavaScriptLexer;
import org.sonar.plugins.javascript.JavaScriptSquidSensor;

public class JavaScriptTokenizer
implements Tokenizer {
    private final Charset charset;
    private final boolean excludeMinified;

    public JavaScriptTokenizer(Charset charset, boolean excludeMinified) {
        this.charset = charset;
        this.excludeMinified = excludeMinified;
    }

    public final void tokenize(SourceCode source, Tokens cpdTokens) {
        Lexer lexer = JavaScriptLexer.create((Charset)this.charset);
        String fileName = source.getFileName();
        if (this.excludeMinified && JavaScriptSquidSensor.isMinifiedFile(fileName)) {
            return;
        }
        List tokens = lexer.lex(new File(fileName));
        for (Token token : tokens) {
            TokenEntry cpdToken = new TokenEntry(JavaScriptTokenizer.getTokenImage(token), fileName, token.getLine());
            cpdTokens.add(cpdToken);
        }
        cpdTokens.add(TokenEntry.getEOF());
    }

    private static String getTokenImage(Token token) {
        if (token.getType() == GenericTokenType.LITERAL) {
            return GenericTokenType.LITERAL.getValue();
        }
        return token.getValue();
    }
}

