/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.lcov;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.config.Settings;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.CoverageMeasuresBuilder;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.PropertiesBuilder;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.plugins.javascript.lcov.LCOVParser;
import org.sonar.plugins.javascript.lcov.UTCoverageSensor;

public abstract class LCOVCoverageSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(UTCoverageSensor.class);
    protected final FileSystem fileSystem;
    protected final Settings settings;
    protected final FilePredicate mainFilePredicate;
    protected Metric linesToCoverMetric;
    protected Metric uncoveredLinesMetric;
    protected Metric coverageLineHitsDataMetric;
    protected Metric coveredConditionsByLineMetric;
    protected Metric conditionsByLineMetric;
    protected Metric uncoveredConditionsMetric;
    protected Metric conditionsToCoverMetric;
    protected String[] reportPaths;

    public LCOVCoverageSensor(FileSystem fileSystem, Settings settings) {
        this.mainFilePredicate = fileSystem.predicates().and(fileSystem.predicates().hasType(InputFile.Type.MAIN), fileSystem.predicates().hasLanguage("js"));
        this.fileSystem = fileSystem;
        this.settings = settings;
    }

    public static File getIOFile(File baseDir, String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(baseDir, path);
        }
        return file;
    }

    private static void checkDataIsNotNull(@Nullable String data) {
        if (data == null) {
            throw new IllegalStateException("Measure data is null but it shouldn't be");
        }
    }

    @DependsUpon
    public Collection<Metric> dependsUponMetrics() {
        return ImmutableList.of((Object)CoreMetrics.NCLOC, (Object)CoreMetrics.NCLOC_DATA);
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.fileSystem.hasFiles(this.mainFilePredicate);
    }

    public void analyse(Project module, SensorContext context) {
        if (this.isLCOVReportProvided()) {
            this.saveMeasureFromLCOVFile(context);
        } else if (this.isForceZeroCoverageActivated()) {
            this.saveZeroValueForAllFiles(context);
        }
    }

    protected void saveZeroValueForAllFiles(SensorContext context) {
        for (InputFile inputFile : this.fileSystem.inputFiles(this.mainFilePredicate)) {
            this.saveZeroValueForResource(org.sonar.api.resources.File.create((String)inputFile.relativePath()), context);
        }
    }

    protected void saveMeasureFromLCOVFile(SensorContext context) {
        LinkedList<File> lcovFiles = new LinkedList<File>();
        for (String reportPath : this.reportPaths) {
            String providedPath = this.settings.getString(reportPath);
            if (StringUtils.isBlank((String)providedPath)) continue;
            File lcovFile = LCOVCoverageSensor.getIOFile(this.fileSystem.baseDir(), providedPath);
            if (lcovFile.isFile()) {
                lcovFiles.add(lcovFile);
                continue;
            }
            LOG.warn("No coverage information will be saved because LCOV file cannot be found. Provided LCOV file path: {}", (Object)providedPath);
            LOG.warn("Provided LCOV file path: {}. Seek file with path: {}", (Object)providedPath, (Object)lcovFile.getAbsolutePath());
        }
        if (lcovFiles.isEmpty()) {
            LOG.warn("No coverage information will be saved because all LCOV files cannot be found.");
            return;
        }
        LOG.info("Analysing {}", lcovFiles);
        LCOVParser parser = LCOVParser.create(this.fileSystem, lcovFiles.toArray(new File[lcovFiles.size()]));
        Map<InputFile, CoverageMeasuresBuilder> coveredFiles = parser.coverageByFile();
        for (InputFile inputFile : this.fileSystem.inputFiles(this.mainFilePredicate)) {
            try {
                CoverageMeasuresBuilder fileCoverage = coveredFiles.get(inputFile);
                org.sonar.api.resources.File resource = org.sonar.api.resources.File.create((String)inputFile.relativePath());
                if (fileCoverage != null) {
                    for (Measure measure : fileCoverage.createMeasures()) {
                        context.saveMeasure((Resource)resource, this.convertMeasure(measure));
                    }
                    continue;
                }
                LOG.debug("Default value of zero will be saved for file: {}", (Object)resource.getPath());
                LOG.debug("Because: either was not present in LCOV report either was not able to retrieve associated SonarQube resource");
                this.saveZeroValueForResource(resource, context);
            }
            catch (Exception e) {
                LOG.error("Problem while calculating coverage for " + inputFile.absolutePath(), (Throwable)e);
            }
        }
        List<String> unresolvedPaths = parser.unresolvedPaths();
        if (!unresolvedPaths.isEmpty()) {
            LOG.warn(String.format("Could not resolve %d file paths in %s, first unresolved path: %s", unresolvedPaths.size(), lcovFiles, unresolvedPaths.get(0)));
        }
    }

    private void saveZeroValueForResource(org.sonar.api.resources.File resource, SensorContext context) {
        Measure nclocMeasure = context.getMeasure((Resource)resource, CoreMetrics.NCLOC);
        if (nclocMeasure != null) {
            double ncloc = nclocMeasure.getValue();
            context.saveMeasure((Resource)resource, this.getZeroCoverageLineHitsDataMetric(resource, context));
            context.saveMeasure((Resource)resource, this.linesToCoverMetric, Double.valueOf(ncloc));
            context.saveMeasure((Resource)resource, this.uncoveredLinesMetric, Double.valueOf(ncloc));
        }
    }

    private Measure getZeroCoverageLineHitsDataMetric(org.sonar.api.resources.File resource, SensorContext context) {
        PropertiesBuilder lineHitsData = new PropertiesBuilder(this.coverageLineHitsDataMetric);
        Measure nclocDataMeasure = context.getMeasure((Resource)resource, CoreMetrics.NCLOC_DATA);
        if (nclocDataMeasure != null) {
            String[] lines;
            String nclocData = nclocDataMeasure.getData();
            if (nclocData == null) {
                return lineHitsData.build();
            }
            for (String line : lines = nclocData.split(";")) {
                String[] info = line.split("=");
                if (info.length != 2 || !"1".equals(info[1])) continue;
                int lineNumber = Integer.parseInt(info[0]);
                lineHitsData.add((Object)lineNumber, (Object)0);
            }
        }
        return lineHitsData.build();
    }

    private boolean isForceZeroCoverageActivated() {
        return this.settings.getBoolean("sonar.javascript.forceZeroCoverage");
    }

    private boolean isLCOVReportProvided() {
        for (String reportPath : this.reportPaths) {
            if (!StringUtils.isNotBlank((String)this.settings.getString(reportPath))) continue;
            return true;
        }
        return false;
    }

    private Measure convertMeasure(Measure measure) {
        Measure itMeasure = null;
        Metric metric = measure.getMetric();
        Double value = measure.getValue();
        String data = measure.getData();
        if (CoreMetrics.LINES_TO_COVER.equals((Object)metric)) {
            itMeasure = new Measure(this.linesToCoverMetric, value);
        } else if (CoreMetrics.UNCOVERED_LINES.equals((Object)metric)) {
            itMeasure = new Measure(this.uncoveredLinesMetric, value);
        } else if (CoreMetrics.COVERAGE_LINE_HITS_DATA.equals((Object)metric)) {
            LCOVCoverageSensor.checkDataIsNotNull(data);
            itMeasure = new Measure(this.coverageLineHitsDataMetric, data);
        } else if (CoreMetrics.CONDITIONS_TO_COVER.equals((Object)metric)) {
            itMeasure = new Measure(this.conditionsToCoverMetric, value);
        } else if (CoreMetrics.UNCOVERED_CONDITIONS.equals((Object)metric)) {
            itMeasure = new Measure(this.uncoveredConditionsMetric, value);
        } else if (CoreMetrics.COVERED_CONDITIONS_BY_LINE.equals((Object)metric)) {
            LCOVCoverageSensor.checkDataIsNotNull(data);
            itMeasure = new Measure(this.coveredConditionsByLineMetric, data);
        } else if (CoreMetrics.CONDITIONS_BY_LINE.equals((Object)metric)) {
            LCOVCoverageSensor.checkDataIsNotNull(data);
            itMeasure = new Measure(this.conditionsByLineMetric, data);
        }
        return itMeasure;
    }
}

