/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.api.PropertyType;
import org.sonar.api.SonarPlugin;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.plugins.javascript.JavaScriptLanguage;
import org.sonar.plugins.javascript.JavaScriptProfile;
import org.sonar.plugins.javascript.JavaScriptSquidSensor;
import org.sonar.plugins.javascript.cpd.JavaScriptCpdMapping;
import org.sonar.plugins.javascript.lcov.ITCoverageSensor;
import org.sonar.plugins.javascript.lcov.UTCoverageSensor;
import org.sonar.plugins.javascript.rules.JavaScriptCommonRulesDecorator;
import org.sonar.plugins.javascript.rules.JavaScriptCommonRulesEngine;
import org.sonar.plugins.javascript.rules.JavaScriptRulesDefinition;
import org.sonar.plugins.javascript.unittest.jstest.JsTestSensor;
import org.sonar.plugins.javascript.unittest.jstestdriver.JsTestDriverSensor;

public class JavaScriptPlugin
extends SonarPlugin {
    private static final String GENERAL = "General";
    private static final String TEST_AND_COVERAGE = "Tests and Coverage";
    private static final String LIBRARIES = "Libraries";
    public static final String FILE_SUFFIXES_KEY = "sonar.javascript.file.suffixes";
    public static final String FILE_SUFFIXES_DEFVALUE = ".js";
    public static final String PROPERTY_PREFIX = "sonar.javascript";
    public static final String LCOV_UT_REPORT_PATH = "sonar.javascript.lcov.reportPath";
    public static final String LCOV_UT_REPORT_PATH_DEFAULT_VALUE = "";
    public static final String LCOV_IT_REPORT_PATH = "sonar.javascript.lcov.itReportPath";
    public static final String LCOV_IT_REPORT_PATH_DEFAULT_VALUE = "";
    public static final String FORCE_ZERO_COVERAGE_KEY = "sonar.javascript.forceZeroCoverage";
    public static final String FORCE_ZERO_COVERAGE_DEFAULT_VALUE = "false";
    public static final String JSTESTDRIVER_REPORTS_PATH = "sonar.javascript.jstestdriver.reportsPath";
    public static final String JSTESTDRIVER_REPORTS_PATH_DEFAULT_VALUE = "";
    public static final String JSTEST_REPORTS_PATH = "sonar.javascript.jstest.reportsPath";
    public static final String JQUERY_OBJECT_ALIASES = "sonar.javascript.jQueryObjectAliases";
    public static final String JQUERY_OBJECT_ALIASES_DEFAULT_VALUE = "$, jQuery";
    public static final String IGNORE_HEADER_COMMENTS = "sonar.javascript.ignoreHeaderComments";
    public static final Boolean IGNORE_HEADER_COMMENTS_DEFAULT_VALUE = true;

    public List getExtensions() {
        return ImmutableList.of(JavaScriptLanguage.class, JavaScriptCpdMapping.class, JavaScriptSquidSensor.class, JavaScriptRulesDefinition.class, JavaScriptProfile.class, JavaScriptCommonRulesEngine.class, JavaScriptCommonRulesDecorator.class, JsTestSensor.class, JsTestDriverSensor.class, UTCoverageSensor.class, ITCoverageSensor.class, (Object)PropertyDefinition.builder((String)FILE_SUFFIXES_KEY).defaultValue(FILE_SUFFIXES_DEFVALUE).name("File Suffixes").description("Comma-separated list of suffixes for files to analyze.").subCategory(GENERAL).onQualifiers("TRK", new String[0]).build(), (Object[])new Object[]{PropertyDefinition.builder((String)IGNORE_HEADER_COMMENTS).defaultValue(IGNORE_HEADER_COMMENTS_DEFAULT_VALUE.toString()).name("Ignore header comments").description("True to not count file header comments in comment metrics.").onQualifiers("BRC", new String[]{"TRK"}).subCategory(GENERAL).type(PropertyType.BOOLEAN).build(), PropertyDefinition.builder((String)LCOV_UT_REPORT_PATH).defaultValue("").name("Unit Tests LCOV File").description("Path (absolute or relative) to the file with LCOV data for unit tests.").onQualifiers("BRC", new String[]{"TRK"}).subCategory(TEST_AND_COVERAGE).build(), PropertyDefinition.builder((String)LCOV_IT_REPORT_PATH).defaultValue("").name("Integration Tests LCOV File").description("Path (absolute or relative) to the file with LCOV data for integration tests.").onQualifiers("BRC", new String[]{"TRK"}).subCategory(TEST_AND_COVERAGE).build(), PropertyDefinition.builder((String)FORCE_ZERO_COVERAGE_KEY).defaultValue(FORCE_ZERO_COVERAGE_DEFAULT_VALUE).name("Force 0 coverage value").description("Force coverage to be set to 0 when no report is provided.").onQualifiers("BRC", new String[]{"TRK"}).type(PropertyType.BOOLEAN).subCategory(TEST_AND_COVERAGE).build(), PropertyDefinition.builder((String)JSTESTDRIVER_REPORTS_PATH).defaultValue("").name("JSTestDriver output folder").description("Folder where JsTestDriver unit test reports are located.").onQualifiers("BRC", new String[]{"TRK"}).subCategory(TEST_AND_COVERAGE).build(), PropertyDefinition.builder((String)JQUERY_OBJECT_ALIASES).defaultValue(JQUERY_OBJECT_ALIASES_DEFAULT_VALUE).name("jQuery object aliases").description("Comma-separated list of names used to address jQuery object.").onQualifiers("BRC", new String[]{"TRK"}).subCategory(LIBRARIES).build()});
    }
}

