/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.RecognitionException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.component.Perspective;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.issue.Issuable;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.resources.Project;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.source.Highlightable;
import org.sonar.api.source.Symbol;
import org.sonar.api.source.Symbolizable;
import org.sonar.php.PHPAnalyzer;
import org.sonar.php.checks.CheckList;
import org.sonar.php.highlighter.SymbolHighlightingData;
import org.sonar.php.highlighter.SyntaxHighlightingData;
import org.sonar.php.metrics.FileMeasures;
import org.sonar.plugins.php.PHPChecks;
import org.sonar.plugins.php.api.visitors.Issue;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PHPCustomRulesDefinition;
import org.sonar.squidbridge.ProgressReport;
import org.sonar.squidbridge.api.AnalysisException;

public class PHPSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(PHPSensor.class);
    private final ResourcePerspectives resourcePerspectives;
    private final FileSystem fileSystem;
    private final FilePredicate mainFilePredicate;
    private final FileLinesContextFactory fileLinesContextFactory;
    private final PHPChecks checks;
    private final NoSonarFilter noSonarFilter;
    private SensorContext context;

    public PHPSensor(ResourcePerspectives resourcePerspectives, FileSystem fileSystem, FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter) {
        this(resourcePerspectives, fileSystem, fileLinesContextFactory, checkFactory, noSonarFilter, null);
    }

    public PHPSensor(ResourcePerspectives resourcePerspectives, FileSystem fileSystem, FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, @Nullable PHPCustomRulesDefinition[] customRulesDefinitions) {
        this.checks = PHPChecks.createPHPCheck(checkFactory).addChecks("php", CheckList.getChecks()).addCustomChecks(customRulesDefinitions);
        this.resourcePerspectives = resourcePerspectives;
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.fileSystem = fileSystem;
        this.noSonarFilter = noSonarFilter;
        this.mainFilePredicate = this.fileSystem.predicates().and(this.fileSystem.predicates().hasType(InputFile.Type.MAIN), this.fileSystem.predicates().hasLanguage("php"));
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.fileSystem.hasFiles(this.mainFilePredicate);
    }

    public void analyse(Project project, SensorContext context) {
        this.context = context;
        ImmutableList<PHPCheck> visitors = this.getCheckVisitors();
        PHPAnalyzer phpAnalyzer = new PHPAnalyzer(this.fileSystem.encoding(), visitors);
        ArrayList inputFiles = Lists.newArrayList((Iterable)this.fileSystem.inputFiles(this.mainFilePredicate));
        ProgressReport progressReport = new ProgressReport("Report about progress of PHP analyzer", TimeUnit.SECONDS.toMillis(10L));
        progressReport.start((Collection)Lists.newArrayList((Iterable)this.fileSystem.files(this.mainFilePredicate)));
        this.analyseFiles(phpAnalyzer, inputFiles, progressReport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void analyseFiles(PHPAnalyzer phpAnalyzer, List<InputFile> inputFiles, ProgressReport progressReport) {
        boolean success = false;
        try {
            for (InputFile inputFile : inputFiles) {
                progressReport.nextFile();
                this.analyseFile(phpAnalyzer, inputFile);
            }
            success = true;
        }
        finally {
            PHPSensor.stopProgressReport(progressReport, success);
        }
    }

    private static void stopProgressReport(ProgressReport progressReport, boolean success) {
        if (success) {
            progressReport.stop();
        } else {
            progressReport.cancel();
        }
    }

    private void analyseFile(PHPAnalyzer phpAnalyzer, InputFile inputFile) {
        try {
            phpAnalyzer.nextFile(inputFile.file());
            this.saveIssues(phpAnalyzer.analyze(), inputFile);
            this.saveSyntaxHighlighting(phpAnalyzer.getSyntaxHighlighting(), inputFile);
            this.saveSymbolHighlighting(phpAnalyzer.getSymbolHighlighting(), inputFile);
            this.saveNewFileMeasures(phpAnalyzer.computeMeasures(this.fileLinesContextFactory.createFor(inputFile)), inputFile);
        }
        catch (RecognitionException e) {
            PHPSensor.checkInterrupted((Exception)((Object)e));
            LOG.error("Unable to parse file: " + inputFile.absolutePath());
            LOG.error(e.getMessage());
            return;
        }
        catch (Exception e) {
            PHPSensor.checkInterrupted(e);
            throw new AnalysisException("Could not analyse " + inputFile.absolutePath(), (Throwable)e);
        }
    }

    private static void checkInterrupted(Exception e) {
        Throwable cause = Throwables.getRootCause((Throwable)e);
        if (cause instanceof InterruptedException || cause instanceof InterruptedIOException) {
            throw new AnalysisException("Analysis cancelled", (Throwable)e);
        }
    }

    private void saveSymbolHighlighting(List<SymbolHighlightingData> highlightingDataList, InputFile inputFile) {
        Symbolizable symbolizable = this.perspective(Symbolizable.class, inputFile);
        if (symbolizable != null) {
            Symbolizable.SymbolTableBuilder symbolTableBuilder = symbolizable.newSymbolTableBuilder();
            for (SymbolHighlightingData symbolHighlightingData : highlightingDataList) {
                Symbol symbol = symbolTableBuilder.newSymbol(symbolHighlightingData.startOffset().intValue(), symbolHighlightingData.endOffset().intValue());
                for (Integer referenceStartOffset : symbolHighlightingData.referencesStartOffset()) {
                    symbolTableBuilder.newReference(symbol, referenceStartOffset.intValue());
                }
            }
            symbolizable.setSymbolTable(symbolTableBuilder.build());
        }
    }

    private void saveSyntaxHighlighting(List<SyntaxHighlightingData> highlightingDataList, InputFile inputFile) {
        Highlightable highlightable = this.perspective(Highlightable.class, inputFile);
        if (highlightable != null) {
            Highlightable.HighlightingBuilder highlightingBuilder = highlightable.newHighlighting();
            for (SyntaxHighlightingData highlightingData : highlightingDataList) {
                highlightingBuilder.highlight(highlightingData.startOffset().intValue(), highlightingData.endOffset().intValue(), highlightingData.highlightCode());
            }
            highlightingBuilder.done();
        }
    }

    @Nullable
    <P extends Perspective<?>> P perspective(Class<P> clazz, InputFile file) {
        Perspective result = this.resourcePerspectives.as(clazz, (InputPath)file);
        if (result == null) {
            LOG.warn("Could not get " + clazz.getCanonicalName() + " for " + file);
        }
        return (P)result;
    }

    private void saveNewFileMeasures(FileMeasures fileMeasures, InputFile inputFile) {
        this.context.saveMeasure(inputFile, CoreMetrics.LINES, Double.valueOf(fileMeasures.getLinesNumber()));
        this.context.saveMeasure(inputFile, CoreMetrics.NCLOC, Double.valueOf(fileMeasures.getLinesOfCodeNumber()));
        this.context.saveMeasure(inputFile, CoreMetrics.COMMENT_LINES, Double.valueOf(fileMeasures.getCommentLinesNumber()));
        this.context.saveMeasure(inputFile, CoreMetrics.CLASSES, Double.valueOf(fileMeasures.getClassNumber()));
        this.context.saveMeasure(inputFile, CoreMetrics.FUNCTIONS, Double.valueOf(fileMeasures.getFunctionNumber()));
        this.context.saveMeasure(inputFile, CoreMetrics.STATEMENTS, Double.valueOf(fileMeasures.getStatementNumber()));
        this.context.saveMeasure(inputFile, CoreMetrics.COMPLEXITY, Double.valueOf(fileMeasures.getFileComplexity()));
        this.context.saveMeasure(inputFile, CoreMetrics.COMPLEXITY_IN_CLASSES, Double.valueOf(fileMeasures.getClassComplexity()));
        this.context.saveMeasure(inputFile, CoreMetrics.COMPLEXITY_IN_FUNCTIONS, Double.valueOf(fileMeasures.getFunctionComplexity()));
        this.context.saveMeasure(inputFile, fileMeasures.getFunctionComplexityDistribution().build(true).setPersistenceMode(PersistenceMode.MEMORY));
        this.context.saveMeasure(inputFile, fileMeasures.getFileComplexityDistribution().build(true).setPersistenceMode(PersistenceMode.MEMORY));
        this.noSonarFilter.addComponent(this.context.getResource((InputPath)inputFile).getEffectiveKey(), fileMeasures.getNoSonarLines());
    }

    private void saveIssues(List<Issue> issues, InputFile inputFile) {
        for (Issue phpIssue : issues) {
            RuleKey ruleKey = this.checks.ruleKeyFor(phpIssue.check());
            Issuable issuable = (Issuable)this.resourcePerspectives.as(Issuable.class, (InputPath)inputFile);
            if (issuable == null) continue;
            Issuable.IssueBuilder issueBuilder = issuable.newIssueBuilder().ruleKey(ruleKey).message(phpIssue.message()).effortToFix(phpIssue.cost());
            if (phpIssue.line() > 0) {
                issueBuilder.line(Integer.valueOf(phpIssue.line()));
            }
            issuable.addIssue(issueBuilder.build());
        }
    }

    private ImmutableList<PHPCheck> getCheckVisitors() {
        return ImmutableList.copyOf(this.checks.all());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

