/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.core;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.php.api.PHPKeyword;
import org.sonar.squidbridge.measures.Metric;
import org.sonar.squidbridge.recognizer.CamelCaseDetector;
import org.sonar.squidbridge.recognizer.CodeRecognizer;
import org.sonar.squidbridge.recognizer.ContainsDetector;
import org.sonar.squidbridge.recognizer.Detector;
import org.sonar.squidbridge.recognizer.EndWithDetector;
import org.sonar.squidbridge.recognizer.KeywordsDetector;
import org.sonar.squidbridge.recognizer.LanguageFootprint;
import org.sonar.squidbridge.text.Source;

@Phase(name=Phase.Name.PRE)
public class NoSonarAndCommentedOutLocSensor
implements Sensor {
    private static final double CODE_RECOGNIZER_SENSITIVITY = 0.9;
    private static final Logger LOG = LoggerFactory.getLogger(NoSonarAndCommentedOutLocSensor.class);
    private final NoSonarFilter filter;
    private final FileSystem filesystem;
    private final FilePredicates filePredicates;

    public NoSonarAndCommentedOutLocSensor(FileSystem filesystem, NoSonarFilter noSonarFilter) {
        this.filter = noSonarFilter;
        this.filesystem = filesystem;
        this.filePredicates = filesystem.predicates();
    }

    public void analyse(Project project, SensorContext context) {
        Iterable sourceFiles = this.filesystem.inputFiles(this.filePredicates.and(this.filePredicates.hasLanguage("php"), this.filePredicates.hasType(InputFile.Type.MAIN)));
        for (InputFile file : sourceFiles) {
            Source source;
            org.sonar.api.resources.File phpFile = (org.sonar.api.resources.File)context.getResource((Resource)org.sonar.api.resources.File.create((String)file.relativePath()));
            if (phpFile == null || (source = NoSonarAndCommentedOutLocSensor.analyseSourceCode(file.file(), this.filesystem.encoding())) == null) continue;
            this.filter.addComponent(phpFile.getEffectiveKey(), source.getNoSonarTagLines());
            double measure = source.getMeasure(Metric.COMMENTED_OUT_CODE_LINES);
            context.saveMeasure((Resource)phpFile, CoreMetrics.COMMENTED_OUT_CODE_LINES, Double.valueOf(measure));
        }
    }

    @VisibleForTesting
    org.sonar.api.resources.File getSonarResource(Project project, File file) {
        return org.sonar.api.resources.File.fromIOFile((File)file, (Project)project);
    }

    protected static Source analyseSourceCode(File file, Charset charset) {
        Source result = null;
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), charset);){
            result = new Source((Reader)reader, new CodeRecognizer(0.9, (LanguageFootprint)new PhpLanguageFootprint()), new String[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to open file '" + file.getAbsolutePath() + "'", e);
        }
        catch (RuntimeException rEx) {
            LOG.error("Error while parsing file '" + file.getAbsolutePath() + "'", (Throwable)rEx);
        }
        return result;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.filesystem.hasFiles(this.filePredicates.and(this.filePredicates.hasLanguage("php"), this.filePredicates.hasType(InputFile.Type.MAIN)));
    }

    public String toString() {
        return "NoSonar and Commented out LOC Sensor";
    }

    private static class PhpLanguageFootprint
    implements LanguageFootprint {
        private static final double CAMEL_CASE_PROBABILITY = 0.5;
        private static final double CONDITIONAL_PROBABILITY = 0.95;
        private static final double PHP_KEYWORDS_PROBABILITY = 0.3;
        private static final double BOOLEAN_OPERATOR_PROBABILITY = 0.7;
        private static final double END_WITH_DETECTOR_PROBABILITY = 0.95;
        private final Set<Detector> detectors = new HashSet<Detector>();

        public PhpLanguageFootprint() {
            this.detectors.add((Detector)new EndWithDetector(0.95, new char[]{'}', ';', '{'}));
            this.detectors.add((Detector)new KeywordsDetector(0.7, new String[]{"||", "&&"}));
            this.detectors.add((Detector)new KeywordsDetector(0.3, PHPKeyword.getKeywordValues()));
            this.detectors.add((Detector)new ContainsDetector(0.95, new String[]{"++", "for(", "if(", "while(", "catch(", "switch(", "try{", "else{"}));
            this.detectors.add((Detector)new CamelCaseDetector(0.5));
        }

        public Set<Detector> getDetectors() {
            return this.detectors;
        }
    }
}

