/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.duplications;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import org.sonar.api.batch.AbstractCpdMapping;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;
import org.sonar.duplications.token.Token;
import org.sonar.duplications.token.TokenChunker;
import org.sonar.duplications.token.TokenQueue;
import org.sonar.plugins.php.api.Php;
import org.sonar.plugins.php.duplications.PhpTokenProducer;

public class PhpCPDMapping
extends AbstractCpdMapping {
    private Php php;
    private FileSystem fileSystem;

    public PhpCPDMapping(Php php, Project project, FileSystem fileSystem) {
        this.php = php;
        this.fileSystem = fileSystem;
    }

    public Language getLanguage() {
        return this.php;
    }

    public Tokenizer getTokenizer() {
        return new PHPCPDTokenizer();
    }

    class PHPCPDTokenizer
    implements Tokenizer {
        private TokenChunker tokenChunker = PhpTokenProducer.build();
        private static final String USE_KEYWORD = "use";
        private static final String SEMI_COLON = ";";

        public final void tokenize(SourceCode source, Tokens cpdTokens) {
            String fileName = source.getFileName();
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(fileName), PhpCPDMapping.this.fileSystem.encoding());){
                TokenQueue queue = this.tokenChunker.chunk((Reader)reader);
                Iterator iterator = queue.iterator();
                boolean useDirective = false;
                while (iterator.hasNext()) {
                    Token token = (Token)iterator.next();
                    if (token.getValue().equalsIgnoreCase(USE_KEYWORD)) {
                        useDirective = true;
                        continue;
                    }
                    if (useDirective) {
                        if (!token.getValue().equalsIgnoreCase(SEMI_COLON)) continue;
                        useDirective = false;
                        continue;
                    }
                    cpdTokens.add(new TokenEntry(token.getValue(), fileName, token.getLine()));
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            cpdTokens.add(TokenEntry.getEOF());
        }
    }
}

