/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.phpunit;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchExtension;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.PropertiesBuilder;
import org.sonar.api.resources.Resource;
import org.sonar.plugins.php.phpunit.PhpUnitParser;
import org.sonar.plugins.php.phpunit.xml.CoverageNode;
import org.sonar.plugins.php.phpunit.xml.FileNode;
import org.sonar.plugins.php.phpunit.xml.LineNode;
import org.sonar.plugins.php.phpunit.xml.MetricsNode;
import org.sonar.plugins.php.phpunit.xml.PackageNode;
import org.sonar.plugins.php.phpunit.xml.ProjectNode;

public class PhpUnitCoverageResultParser
implements BatchExtension,
PhpUnitParser {
    private static final Map<Resource, Measure> MEASURES_BY_RESOURCE = new HashMap<Resource, Measure>();
    private static final Logger LOG = LoggerFactory.getLogger(PhpUnitCoverageResultParser.class);
    private final SensorContext context;
    private final FileSystem fileSystem;
    protected Metric<Integer> linesToCoverMetric = CoreMetrics.LINES_TO_COVER;
    protected Metric<Integer> uncoveredLinesMetric = CoreMetrics.UNCOVERED_LINES;
    protected Metric<String> coverageLineHitsDataMetric = CoreMetrics.COVERAGE_LINE_HITS_DATA;
    private static final String WRONG_LINE_EXCEPTION_MESSAGE = "Line with number %s doesn't belong to file %s";

    public PhpUnitCoverageResultParser(SensorContext context, FileSystem fileSystem) {
        this.context = context;
        this.fileSystem = fileSystem;
    }

    @Override
    public void parse(File coverageReportFile) {
        LOG.debug("Parsing file: " + coverageReportFile.getAbsolutePath());
        this.parseFile(coverageReportFile);
    }

    private void parseFile(File coverageReportFile) {
        CoverageNode coverage = this.getCoverage(coverageReportFile);
        ArrayList<String> unresolvedPaths = new ArrayList<String>();
        ArrayList<String> resolvedPaths = new ArrayList<String>();
        List<ProjectNode> projects = coverage.getProjects();
        if (projects != null && !projects.isEmpty()) {
            ProjectNode projectNode = projects.get(0);
            this.parseFileNodes(projectNode.getFiles(), unresolvedPaths, resolvedPaths);
            this.parsePackagesNodes(projectNode.getPackages(), unresolvedPaths, resolvedPaths);
            this.saveMeasureForMissingFiles(resolvedPaths);
        }
        if (!unresolvedPaths.isEmpty()) {
            LOG.warn(String.format("Could not resolve %d file paths in %s, first unresolved path: %s", unresolvedPaths.size(), coverageReportFile.getName(), unresolvedPaths.get(0)));
        }
    }

    private void saveMeasureForMissingFiles(List<String> resolvedPaths) {
        FilePredicate mainFilesPredicate = this.fileSystem.predicates().and(this.fileSystem.predicates().hasType(InputFile.Type.MAIN), this.fileSystem.predicates().hasLanguage("php"));
        for (InputFile phpFile : this.fileSystem.inputFiles(mainFilesPredicate)) {
            if (resolvedPaths.contains(phpFile.relativePath())) continue;
            org.sonar.api.resources.File resource = org.sonar.api.resources.File.create((String)phpFile.relativePath());
            LOG.debug("Coverage metrics have not been set on '{}': default values will be inserted.", (Object)phpFile.file().getName());
            Measure ncloc = this.context.getMeasure((Resource)resource, CoreMetrics.NCLOC);
            if (ncloc == null) continue;
            this.context.saveMeasure((Resource)resource, this.linesToCoverMetric, ncloc.getValue());
            this.context.saveMeasure((Resource)resource, this.uncoveredLinesMetric, ncloc.getValue());
        }
    }

    private void parsePackagesNodes(List<PackageNode> packages, List<String> unresolvedPaths, List<String> resolvedPaths) {
        if (packages != null) {
            for (PackageNode packageNode : packages) {
                this.parseFileNodes(packageNode.getFiles(), unresolvedPaths, resolvedPaths);
            }
        }
    }

    private void parseFileNodes(List<FileNode> fileNodes, List<String> unresolvedPaths, List<String> resolvedPaths) {
        if (fileNodes != null) {
            for (FileNode file : fileNodes) {
                this.saveCoverageMeasure(file, unresolvedPaths, resolvedPaths);
            }
        }
    }

    protected void saveCoverageMeasure(FileNode fileNode, List<String> unresolvedPaths, List<String> resolvedPaths) {
        String path = fileNode.getName();
        InputFile inputFile = this.fileSystem.inputFile(this.fileSystem.predicates().hasAbsolutePath(path));
        if (inputFile != null) {
            org.sonar.api.resources.File phpFile = org.sonar.api.resources.File.create((String)inputFile.relativePath());
            resolvedPaths.add(inputFile.relativePath());
            this.saveCoverageLineHitsData(fileNode, inputFile, phpFile);
            MetricsNode metrics = fileNode.getMetrics();
            double totalStatementsCount = metrics.getTotalStatementsCount();
            double uncoveredLines = totalStatementsCount - metrics.getCoveredStatements();
            this.context.saveMeasure((Resource)phpFile, this.linesToCoverMetric, Double.valueOf(totalStatementsCount));
            this.context.saveMeasure((Resource)phpFile, this.uncoveredLinesMetric, Double.valueOf(uncoveredLines));
        } else {
            unresolvedPaths.add(path);
        }
    }

    private void saveCoverageLineHitsData(FileNode fileNode, InputFile inputFile, org.sonar.api.resources.File phpFile) {
        PropertiesBuilder lineHits = new PropertiesBuilder(this.coverageLineHitsDataMetric);
        if (fileNode.getLines() != null) {
            for (LineNode line : fileNode.getLines()) {
                int lineNum = line.getNum();
                if (lineNum > 0 && lineNum <= inputFile.lines()) {
                    PhpUnitCoverageResultParser.saveLineMeasure(line, (PropertiesBuilder<Integer, Integer>)lineHits);
                    continue;
                }
                LOG.warn(String.format(WRONG_LINE_EXCEPTION_MESSAGE, lineNum, phpFile.getLongName()));
            }
        }
        Measure measure = lineHits.build();
        PhpUnitCoverageResultParser.logMeasureByResource((Resource)phpFile, measure);
        this.context.saveMeasure((Resource)phpFile, measure);
    }

    private static void logMeasureByResource(Resource resource, Measure measure) {
        if (LOG.isDebugEnabled()) {
            Measure alreadySaved = MEASURES_BY_RESOURCE.get(resource);
            if (alreadySaved == null) {
                MEASURES_BY_RESOURCE.put(resource, measure);
            } else {
                LOG.debug("Measure {} already saved for resource {}", (Object)measure, (Object)resource);
            }
        }
    }

    private static void saveLineMeasure(LineNode line, PropertiesBuilder<Integer, Integer> lineHits) {
        lineHits.add((Object)line.getNum(), (Object)line.getCount());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoverageNode getCoverage(File coverageReportFile) {
        try (FileInputStream inputStream = new FileInputStream(coverageReportFile);){
            XStream xstream = new XStream();
            xstream.setClassLoader(this.getClass().getClassLoader());
            xstream.aliasSystemAttribute("classType", "class");
            xstream.processAnnotations(CoverageNode.class);
            xstream.processAnnotations(ProjectNode.class);
            xstream.processAnnotations(FileNode.class);
            xstream.processAnnotations(MetricsNode.class);
            xstream.processAnnotations(LineNode.class);
            CoverageNode coverageNode = (CoverageNode)xstream.fromXML((InputStream)inputStream);
            return coverageNode;
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't read phpUnit report: " + coverageReportFile.getName(), e);
        }
    }

    public String toString() {
        return "PHPUnit Unit Test Coverage Result Parser";
    }
}

