/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.phpunit;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchExtension;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.plugins.php.phpunit.PhpTestSuiteReader;
import org.sonar.plugins.php.phpunit.PhpUnitParser;
import org.sonar.plugins.php.phpunit.PhpUnitTestReport;
import org.sonar.plugins.php.phpunit.xml.TestCase;
import org.sonar.plugins.php.phpunit.xml.TestSuite;
import org.sonar.plugins.php.phpunit.xml.TestSuites;

public class PhpUnitResultParser
implements BatchExtension,
PhpUnitParser {
    private static final double PERCENT = 100.0;
    private static final double MILLISECONDS = 1000.0;
    private static final int PRECISION = 1;
    private static final Logger LOG = LoggerFactory.getLogger(PhpUnitResultParser.class);
    private SensorContext context;
    private FileSystem fileSystem;
    private FilePredicates filePredicates;

    public PhpUnitResultParser(SensorContext context, FileSystem fileSystem) {
        this.context = context;
        this.fileSystem = fileSystem;
        this.filePredicates = fileSystem.predicates();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected TestSuites getTestSuites(File report) {
        try (FileInputStream inputStream = new FileInputStream(report);){
            XStream xstream = this.getXStream();
            TestSuites testSuites = (TestSuites)xstream.fromXML((InputStream)inputStream);
            LOG.debug("Tests suites: " + testSuites.getTestSuiteList());
            TestSuites testSuites2 = testSuites;
            return testSuites2;
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't read PhpUnit report : " + report.getAbsolutePath(), e);
        }
    }

    private XStream getXStream() {
        XStream xstream = new XStream(){

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return new MapperWrapper((Mapper)next){

                    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                        return definedIn != Object.class && super.shouldSerializeMember(definedIn, fieldName);
                    }
                };
            }
        };
        xstream.setClassLoader(this.getClass().getClassLoader());
        xstream.aliasSystemAttribute("fileName", "class");
        xstream.processAnnotations(TestSuites.class);
        xstream.processAnnotations(TestSuite.class);
        xstream.processAnnotations(TestCase.class);
        return xstream;
    }

    private InputFile getUnitTestInputFile(PhpUnitTestReport report) {
        return this.fileSystem.inputFile(this.fileSystem.predicates().and(new FilePredicate[]{this.filePredicates.hasPath(report.getFile()), this.filePredicates.hasType(InputFile.Type.TEST), this.filePredicates.hasLanguage("php")}));
    }

    private void insertZeroWhenNoReports() {
        this.context.saveMeasure(CoreMetrics.TESTS, Double.valueOf(0.0));
    }

    @Override
    public void parse(File reportFile) {
        if (reportFile == null) {
            this.insertZeroWhenNoReports();
        } else {
            LOG.debug("Parsing file: " + reportFile.getAbsolutePath());
            this.parseFile(reportFile);
        }
    }

    private void parseFile(File report) {
        TestSuites testSuites = this.getTestSuites(report);
        List<PhpUnitTestReport> fileReports = PhpUnitResultParser.readSuites(testSuites);
        for (PhpUnitTestReport fileReport : fileReports) {
            this.saveTestReportMeasures(fileReport);
        }
    }

    private static List<PhpUnitTestReport> readSuites(TestSuites testSuites) {
        ArrayList<PhpUnitTestReport> result = new ArrayList<PhpUnitTestReport>();
        for (TestSuite testSuite : testSuites.getTestSuiteList()) {
            PhpTestSuiteReader reader = new PhpTestSuiteReader();
            reader.readSuite(testSuite, null);
            result.addAll(reader.getReportsPerClass());
        }
        return result;
    }

    protected void saveTestReportMeasures(PhpUnitTestReport fileReport) {
        if (!fileReport.isValid()) {
            return;
        }
        InputFile unitTestFile = this.getUnitTestInputFile(fileReport);
        if (unitTestFile != null) {
            double testsCount = (double)fileReport.getTests() - (double)fileReport.getSkipped();
            if (fileReport.getSkipped() > 0) {
                this.context.saveMeasure(unitTestFile, CoreMetrics.SKIPPED_TESTS, Double.valueOf(fileReport.getSkipped()));
            }
            double duration = Math.round(fileReport.getTime() * 1000.0);
            this.context.saveMeasure(unitTestFile, CoreMetrics.TEST_EXECUTION_TIME, Double.valueOf(duration));
            this.context.saveMeasure(unitTestFile, CoreMetrics.TESTS, Double.valueOf(testsCount));
            this.context.saveMeasure(unitTestFile, CoreMetrics.TEST_ERRORS, Double.valueOf(fileReport.getErrors()));
            this.context.saveMeasure(unitTestFile, CoreMetrics.TEST_FAILURES, Double.valueOf(fileReport.getFailures()));
            if (testsCount > 0.0) {
                double passedTests = testsCount - (double)fileReport.getErrors() - (double)fileReport.getFailures();
                double percentage = passedTests * 100.0 / testsCount;
                this.context.saveMeasure(unitTestFile, CoreMetrics.TEST_SUCCESS_DENSITY, Double.valueOf(ParsingUtils.scaleValue((double)percentage)));
            }
            this.saveTestsDetails(fileReport);
        } else {
            LOG.debug("Following file is not located in the test folder specified in the Sonar configuration: " + fileReport.getFile() + ". The test results won't be reported in Sonar.");
        }
    }

    private void saveTestsDetails(PhpUnitTestReport fileReport) {
        StringBuilder details = new StringBuilder();
        details.append("<tests-details>");
        for (TestCase detail : fileReport.getDetails()) {
            double time = ParsingUtils.scaleValue((double)(detail.getTime() * 1000.0), (int)1);
            details.append("<testcase status=\"").append(detail.getStatus()).append("\" time=\"");
            details.append(time).append("\" name=\"").append(detail.getName().replaceAll(" ", "_")).append("\"");
            boolean isError = "error".equals(detail.getStatus());
            if (isError || "failure".equals(detail.getStatus())) {
                details.append(">").append(isError ? "<error message=\"" : "<failure message=\"");
                details.append(StringEscapeUtils.escapeXml((String)detail.getErrorMessage())).append("\"><![CDATA[");
                details.append(StringEscapeUtils.escapeXml((String)detail.getStackTrace())).append("]]>");
                details.append(isError ? "</error>" : "</failure>").append("</testcase>");
                continue;
            }
            details.append("/>");
        }
        details.append("</tests-details>");
        InputFile unitTestFile = this.getUnitTestInputFile(fileReport);
        if (unitTestFile != null) {
            this.context.saveMeasure(unitTestFile, new Measure(CoreMetrics.TEST_DATA, details.toString()));
        }
    }
}

