/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.phpunit;

import com.thoughtworks.xstream.XStreamException;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Project;
import org.sonar.plugins.php.phpunit.PhpUnitCoverageResultParser;
import org.sonar.plugins.php.phpunit.PhpUnitItCoverageResultParser;
import org.sonar.plugins.php.phpunit.PhpUnitOverallCoverageResultParser;
import org.sonar.plugins.php.phpunit.PhpUnitParser;
import org.sonar.plugins.php.phpunit.PhpUnitResultParser;

public class PhpUnitSensor
implements Sensor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhpUnitSensor.class);
    private final Settings settings;
    private final PhpUnitOverallCoverageResultParser overallCoverageParser;
    private final PhpUnitItCoverageResultParser itCoverageParser;
    private final PhpUnitCoverageResultParser coverageParser;
    private final PhpUnitResultParser parser;
    private final FileSystem fileSystem;
    private final FilePredicates filePredicates;

    public PhpUnitSensor(FileSystem fileSystem, Settings settings, PhpUnitResultParser parser, PhpUnitCoverageResultParser coverageParser, PhpUnitItCoverageResultParser itCoverageParser, PhpUnitOverallCoverageResultParser overallCoverageParser) {
        this.fileSystem = fileSystem;
        this.filePredicates = fileSystem.predicates();
        this.settings = settings;
        this.parser = parser;
        this.coverageParser = coverageParser;
        this.itCoverageParser = itCoverageParser;
        this.overallCoverageParser = overallCoverageParser;
    }

    public void analyse(Project project, SensorContext context) {
        this.parseReport("sonar.php.tests.reportPath", this.parser, "test");
        this.parseReport("sonar.php.coverage.reportPath", this.coverageParser, "unit test coverage");
        this.parseReport("sonar.php.coverage.itReportPath", this.itCoverageParser, "integration test coverage");
        this.parseReport("sonar.php.coverage.overallReportPath", this.overallCoverageParser, "overall coverage");
    }

    private void parseReport(String reportPathKey, PhpUnitParser parser, String msg) {
        String reportPath = this.settings.getString(reportPathKey);
        if (reportPath != null) {
            File xmlFile = this.getIOFile(reportPath);
            if (xmlFile.exists()) {
                LOGGER.info("Analyzing PHPUnit " + msg + " report: " + reportPath + " with " + parser.toString());
                try {
                    parser.parse(xmlFile);
                }
                catch (XStreamException e) {
                    throw new IllegalStateException("Report file is invalid, plugin will stop.", e);
                }
            } else {
                LOGGER.info("PHPUnit xml " + msg + " report not found: " + reportPath);
            }
        } else {
            LOGGER.info("No PHPUnit " + msg + " report provided (see '" + reportPathKey + "' property)");
        }
    }

    private File getIOFile(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(this.fileSystem.baseDir(), path);
        }
        return file;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.fileSystem.hasFiles(this.filePredicates.and(this.filePredicates.hasLanguage("php"), this.filePredicates.hasType(InputFile.Type.MAIN)));
    }

    public String toString() {
        return "PHPUnit Sensor";
    }
}

