/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.python.it.plugin;

import com.sonar.orchestrator.build.Build;
import com.sonar.python.it.ConcurrentOrchestratorExtension;
import com.sonar.python.it.TestsUtils;
import java.io.File;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Issues;

public class Flake8ReportTest {
    private static final String PROJECT = "flake8_project";
    @RegisterExtension
    public static final ConcurrentOrchestratorExtension ORCHESTRATOR = TestsUtils.dynamicOrchestrator;

    @Test
    void import_report() {
        ORCHESTRATOR.getServer().provisionProject(PROJECT, PROJECT);
        ORCHESTRATOR.getServer().associateProjectToQualityProfile(PROJECT, "py", "no_rule");
        ORCHESTRATOR.executeBuild((Build)ORCHESTRATOR.createSonarScanner().setProjectDir(new File("projects/flake8_project")));
        List issues = TestsUtils.issues((String)PROJECT);
        Assertions.assertThat((List)issues).hasSize(5);
        Issues.Issue issue = (Issues.Issue)issues.get(0);
        Assertions.assertThat((String)issue.getComponent()).isEqualTo("flake8_project:src/file1.py");
        Assertions.assertThat((String)issue.getRule()).isEqualTo("external_flake8:E302");
        Assertions.assertThat((String)issue.getMessage()).isEqualTo("expected 2 blank lines, found 1");
        Assertions.assertThat((Comparable)issue.getType()).isEqualTo((Object)Common.RuleType.CODE_SMELL);
        Assertions.assertThat((Comparable)issue.getSeverity()).isEqualTo((Object)Common.Severity.MAJOR);
        Assertions.assertThat((String)issue.getEffort()).isEqualTo("5min");
        issue = (Issues.Issue)issues.get(4);
        Assertions.assertThat((String)issue.getComponent()).isEqualTo("flake8_project:src/file1.py");
        Assertions.assertThat((String)issue.getRule()).isEqualTo("external_flake8:C901");
        Assertions.assertThat((String)issue.getMessage()).isEqualTo("'bar' is too complex (6)");
        Assertions.assertThat((Comparable)issue.getType()).isEqualTo((Object)Common.RuleType.CODE_SMELL);
        Assertions.assertThat((Comparable)issue.getSeverity()).isEqualTo((Object)Common.Severity.MAJOR);
        Assertions.assertThat((String)issue.getEffort()).isEqualTo("5min");
    }
}

