/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.python.it.plugin;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.sonar.orchestrator.build.Build;
import com.sonar.orchestrator.build.BuildResult;
import com.sonar.orchestrator.build.SonarScanner;
import com.sonar.python.it.ConcurrentOrchestratorExtension;
import com.sonar.python.it.TestsUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestReportTest {
    public static final String TESTS = "tests";
    public static final String TEST_FAILURES = "test_failures";
    public static final String TEST_ERRORS = "test_errors";
    public static final String SKIPPED_TESTS = "skipped_tests";
    public static final String TEST_SUCCESS_DENSITY = "test_success_density";
    public static final String TEST_EXECUTION_TIME = "test_execution_time";
    @RegisterExtension
    public static final ConcurrentOrchestratorExtension ORCHESTRATOR = TestsUtils.dynamicOrchestrator;

    private static SonarScanner createBuild(String projectKey, String testReportPath) {
        return (SonarScanner)ORCHESTRATOR.createSonarScanner().setProjectKey(projectKey).setProjectName(projectKey).setProjectDir(new File("projects/nosetests_project")).setProperty("sonar.python.xunit.reportPath", testReportPath);
    }

    @Test
    void import_report() {
        String projectKey = "nosetests_project";
        ORCHESTRATOR.executeBuild((Build)TestReportTest.createBuild("nosetests_project", "nosetests.xml"));
        TestsUtils.assertProjectMeasures((String)"nosetests_project", (Map)new ImmutableMap.Builder().put((Object)TESTS, (Object)3).put((Object)TEST_FAILURES, (Object)1).put((Object)TEST_ERRORS, (Object)1).put((Object)SKIPPED_TESTS, (Object)1).put((Object)TEST_SUCCESS_DENSITY, (Object)33).put((Object)TEST_EXECUTION_TIME, (Object)1).build());
    }

    @Test
    void import_pytest_report() {
        String projectKey = "pytest";
        ORCHESTRATOR.executeBuild((Build)TestReportTest.createBuild("pytest", "pytest.xml"));
        TestsUtils.assertProjectMeasures((String)"pytest", (Map)new ImmutableMap.Builder().put((Object)TESTS, (Object)3).put((Object)TEST_FAILURES, (Object)2).put((Object)TEST_ERRORS, (Object)0).put((Object)SKIPPED_TESTS, (Object)1).put((Object)TEST_SUCCESS_DENSITY, (Object)33).put((Object)TEST_EXECUTION_TIME, (Object)1).build());
    }

    @Test
    void simple_mode() {
        String projectKey = "nosetests_simple";
        ORCHESTRATOR.executeBuild(TestReportTest.createBuild("nosetests_simple", "nosetests.xml").setProperty("sonar.python.xunit.skipDetails", "true"));
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put(TESTS, 3);
        values.put(TEST_FAILURES, 1);
        values.put(TEST_ERRORS, 1);
        values.put(SKIPPED_TESTS, 1);
        values.put(TEST_EXECUTION_TIME, 1);
        values.put(TEST_SUCCESS_DENSITY, null);
        TestsUtils.assertProjectMeasures((String)"nosetests_simple", values);
    }

    @Test
    void missing_test_report() {
        String projectKey = "nosetests_missing";
        ORCHESTRATOR.executeBuild((Build)TestReportTest.createBuild("nosetests_missing", "missing.xml"));
        TestsUtils.assertProjectMeasures((String)"nosetests_missing", TestReportTest.nullMeasures());
    }

    @Test
    void missing_test_report_with_simple_mode() {
        String projectKey = "nosetests_missing_simple";
        ORCHESTRATOR.executeBuild(TestReportTest.createBuild("nosetests_missing_simple", "missing.xml").setProperty("sonar.python.xunit.skipDetails", "true"));
        TestsUtils.assertProjectMeasures((String)"nosetests_missing_simple", TestReportTest.nullMeasures());
    }

    @Test
    void invalid_test_report() {
        String projectKey = "nosetests_invalid";
        BuildResult result = ORCHESTRATOR.executeBuildQuietly((Build)TestReportTest.createBuild("nosetests_invalid", "invalid_report.xml"));
        Assertions.assertThat((boolean)result.isSuccess()).isTrue();
        Assertions.assertThat((String)result.getLogs()).contains(new CharSequence[]{"Cannot read report 'invalid_report.xml', the following exception occurred: Unexpected character 't' (code 116) in prolog; expected '<'\n at [row,col {unknown-source}]: [1,1]"});
    }

    private static Map<String, Integer> nullMeasures() {
        ImmutableSet metrics = ImmutableSet.of((Object)TESTS, (Object)TEST_FAILURES, (Object)TEST_ERRORS, (Object)SKIPPED_TESTS, (Object)TEST_SUCCESS_DENSITY, (Object)TEST_EXECUTION_TIME, (Object[])new String[0]);
        return Maps.asMap((Set)metrics, i -> null);
    }
}

