/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.python.it.plugin;

import com.sonar.orchestrator.build.Build;
import com.sonar.python.it.ConcurrentOrchestratorExtension;
import com.sonar.python.it.TestsUtils;
import java.io.File;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Issues;

public class BanditReportTest {
    private static final String PROJECT = "bandit_project";
    @RegisterExtension
    public static final ConcurrentOrchestratorExtension ORCHESTRATOR = TestsUtils.dynamicOrchestrator;

    @Test
    void import_report() {
        ORCHESTRATOR.getServer().provisionProject(PROJECT, PROJECT);
        ORCHESTRATOR.getServer().associateProjectToQualityProfile(PROJECT, "py", "no_rule");
        ORCHESTRATOR.executeBuild((Build)ORCHESTRATOR.createSonarScanner().setProjectDir(new File("projects/bandit_project")));
        List issues = TestsUtils.issues((String)PROJECT);
        Assertions.assertThat((List)issues).hasSize(1);
        Issues.Issue issue = (Issues.Issue)issues.get(0);
        Assertions.assertThat((String)issue.getComponent()).isEqualTo("bandit_project:src/file1.py");
        Assertions.assertThat((String)issue.getRule()).isEqualTo("external_bandit:B107");
        Assertions.assertThat((String)issue.getMessage()).isEqualTo("Possible hardcoded password: 'secret'");
        Assertions.assertThat((Comparable)issue.getType()).isEqualTo((Object)Common.RuleType.VULNERABILITY);
        Assertions.assertThat((Comparable)issue.getSeverity()).isEqualTo((Object)Common.Severity.MINOR);
        Assertions.assertThat((String)issue.getEffort()).isEqualTo("5min");
    }
}

