/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.python.it.plugin;

import com.sonar.orchestrator.build.Build;
import com.sonar.orchestrator.build.SonarScanner;
import com.sonar.python.it.ConcurrentOrchestratorExtension;
import com.sonar.python.it.TestsUtils;
import java.io.File;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class MetricsTest {
    private static final String PROJECT_KEY = "metrics";
    private static final String CLASSES = "classes";
    private static final String COGNITIVE_COMPLEXITY = "cognitive_complexity";
    private static final String COMMENT_LINES = "comment_lines";
    private static final String COMMENT_LINES_DENSITY = "comment_lines_density";
    private static final String COMPLEXITY = "complexity";
    private static final String COVERAGE = "coverage";
    private static final String DUPLICATED_BLOCKS = "duplicated_blocks";
    private static final String DUPLICATED_FILES = "duplicated_files";
    private static final String DUPLICATED_LINES = "duplicated_lines";
    private static final String DUPLICATED_LINES_DENSITY = "duplicated_lines_density";
    private static final String FILES = "files";
    private static final String FUNCTIONS = "functions";
    private static final String LINES = "lines";
    private static final String NCLOC = "ncloc";
    private static final String STATEMENTS = "statements";
    private static final String TESTS = "tests";
    private static final String VIOLATIONS = "violations";
    private static final String HELLO_WORLD_PY = "dir/HelloWorld.py";
    private static final Offset<Double> OFFSET = Offset.offset((Number)0.01);
    @RegisterExtension
    public static final ConcurrentOrchestratorExtension orchestrator = TestsUtils.dynamicOrchestrator;

    @BeforeAll
    static void startServer() {
        orchestrator.getServer().provisionProject(PROJECT_KEY, PROJECT_KEY);
        orchestrator.getServer().associateProjectToQualityProfile(PROJECT_KEY, "py", "no_rule");
        SonarScanner build = orchestrator.createSonarScanner().setProjectDir(new File("projects/metrics")).setProjectKey(PROJECT_KEY).setProjectName(PROJECT_KEY).setProjectVersion("1.0-SNAPSHOT").setTestDirs("test").setSourceDirs("src");
        orchestrator.executeBuild((Build)build);
    }

    @Test
    void project_level() {
        Assertions.assertThat((Integer)this.getProjectMeasureAsInt(NCLOC)).isEqualTo(6);
        Assertions.assertThat((Integer)this.getProjectMeasureAsInt(LINES)).isEqualTo(13);
        Assertions.assertThat((Integer)this.getProjectMeasureAsInt(FILES)).isEqualTo(2);
        Assertions.assertThat((Integer)this.getProjectMeasureAsInt(STATEMENTS)).isEqualTo(6);
        Assertions.assertThat((Integer)this.getProjectMeasureAsInt(FUNCTIONS)).isOne();
        Assertions.assertThat((Integer)this.getProjectMeasureAsInt(CLASSES)).isZero();
        Assertions.assertThat((Integer)this.getProjectMeasureAsInt(COMMENT_LINES)).isOne();
        Assertions.assertThat((Double)this.getProjectMeasureAsDouble(COMMENT_LINES_DENSITY)).isEqualTo(14.3, OFFSET);
        Assertions.assertThat((Double)this.getProjectMeasureAsDouble(COMPLEXITY)).isEqualTo(3.0, OFFSET);
        Assertions.assertThat((Double)this.getProjectMeasureAsDouble(COGNITIVE_COMPLEXITY)).isEqualTo(3.0, OFFSET);
        Assertions.assertThat((Double)this.getProjectMeasureAsDouble(DUPLICATED_LINES)).isEqualTo(0.0, OFFSET);
        Assertions.assertThat((Double)this.getProjectMeasureAsDouble(DUPLICATED_BLOCKS)).isEqualTo(0.0, OFFSET);
        Assertions.assertThat((Double)this.getProjectMeasureAsDouble(DUPLICATED_FILES)).isEqualTo(0.0, OFFSET);
        Assertions.assertThat((Double)this.getProjectMeasureAsDouble(DUPLICATED_LINES_DENSITY)).isEqualTo(0.0, OFFSET);
        Assertions.assertThat((Double)this.getProjectMeasureAsDouble(VIOLATIONS)).isEqualTo(0.0, OFFSET);
        Assertions.assertThat((Integer)this.getProjectMeasureAsInt(TESTS)).isNull();
        Assertions.assertThat((Double)this.getProjectMeasureAsDouble(COVERAGE)).isEqualTo(0.0, OFFSET);
    }

    @Test
    void directory_level() {
        Assertions.assertThat((Integer)this.getDirectoryMeasureAsInt(NCLOC)).isEqualTo(6);
        Assertions.assertThat((Integer)this.getDirectoryMeasureAsInt(LINES)).isEqualTo(13);
        Assertions.assertThat((Integer)this.getDirectoryMeasureAsInt(FILES)).isEqualTo(2);
        Assertions.assertThat((Integer)this.getDirectoryMeasureAsInt(STATEMENTS)).isEqualTo(6);
        Assertions.assertThat((Integer)this.getDirectoryMeasureAsInt(FUNCTIONS)).isOne();
        Assertions.assertThat((Integer)this.getDirectoryMeasureAsInt(CLASSES)).isZero();
        Assertions.assertThat((Integer)this.getDirectoryMeasureAsInt(COMMENT_LINES)).isOne();
        Assertions.assertThat((Double)this.getDirectoryMeasureAsDouble(COMMENT_LINES_DENSITY)).isEqualTo(14.3, OFFSET);
        Assertions.assertThat((Double)this.getDirectoryMeasureAsDouble(COMPLEXITY)).isEqualTo(3.0, OFFSET);
        Assertions.assertThat((Double)this.getDirectoryMeasureAsDouble(COGNITIVE_COMPLEXITY)).isEqualTo(3.0, OFFSET);
        Assertions.assertThat((Double)this.getDirectoryMeasureAsDouble(DUPLICATED_LINES)).isEqualTo(0.0, OFFSET);
        Assertions.assertThat((Double)this.getDirectoryMeasureAsDouble(DUPLICATED_BLOCKS)).isEqualTo(0.0, OFFSET);
        Assertions.assertThat((Double)this.getDirectoryMeasureAsDouble(DUPLICATED_FILES)).isEqualTo(0.0, OFFSET);
        Assertions.assertThat((Double)this.getDirectoryMeasureAsDouble(DUPLICATED_LINES_DENSITY)).isEqualTo(0.0, OFFSET);
        Assertions.assertThat((Double)this.getDirectoryMeasureAsDouble(VIOLATIONS)).isEqualTo(0.0, OFFSET);
    }

    @Test
    void file_level() {
        Assertions.assertThat((Integer)this.getFileMeasureAsInt(NCLOC)).isOne();
        Assertions.assertThat((Integer)this.getFileMeasureAsInt(LINES)).isEqualTo(6);
        Assertions.assertThat((Integer)this.getFileMeasureAsInt(FILES)).isOne();
        Assertions.assertThat((Integer)this.getFileMeasureAsInt(STATEMENTS)).isEqualTo(2);
        Assertions.assertThat((Integer)this.getFileMeasureAsInt(FUNCTIONS)).isOne();
        Assertions.assertThat((Integer)this.getFileMeasureAsInt(CLASSES)).isZero();
        Assertions.assertThat((Integer)this.getFileMeasureAsInt(COMMENT_LINES)).isOne();
        Assertions.assertThat((Double)this.getFileMeasureAsDouble(COMMENT_LINES_DENSITY)).isEqualTo(50.0, OFFSET);
        Assertions.assertThat((Double)this.getFileMeasureAsDouble(COMPLEXITY)).isEqualTo(2.0, OFFSET);
        Assertions.assertThat((Double)this.getFileMeasureAsDouble(COGNITIVE_COMPLEXITY)).isEqualTo(1.0, OFFSET);
        Assertions.assertThat((Integer)this.getFileMeasureAsInt(DUPLICATED_LINES)).isZero();
        Assertions.assertThat((Integer)this.getFileMeasureAsInt(DUPLICATED_BLOCKS)).isZero();
        Assertions.assertThat((Integer)this.getFileMeasureAsInt(DUPLICATED_FILES)).isZero();
        Assertions.assertThat((Double)this.getFileMeasureAsDouble(DUPLICATED_LINES_DENSITY)).isZero();
        Assertions.assertThat((Integer)this.getFileMeasureAsInt(VIOLATIONS)).isZero();
    }

    private Integer getProjectMeasureAsInt(String metricKey) {
        return TestsUtils.getMeasureAsInt((String)PROJECT_KEY, (String)metricKey);
    }

    private Double getProjectMeasureAsDouble(String metricKey) {
        return TestsUtils.getMeasureAsDouble((String)PROJECT_KEY, (String)metricKey);
    }

    private Integer getDirectoryMeasureAsInt(String metricKey) {
        return TestsUtils.getMeasureAsInt((String)MetricsTest.keyFor("dir"), (String)metricKey);
    }

    private Double getDirectoryMeasureAsDouble(String metricKey) {
        return TestsUtils.getMeasureAsDouble((String)MetricsTest.keyFor("dir"), (String)metricKey);
    }

    private Integer getFileMeasureAsInt(String metricKey) {
        return TestsUtils.getMeasureAsInt((String)MetricsTest.keyFor(HELLO_WORLD_PY), (String)metricKey);
    }

    private Double getFileMeasureAsDouble(String metricKey) {
        return TestsUtils.getMeasureAsDouble((String)MetricsTest.keyFor(HELLO_WORLD_PY), (String)metricKey);
    }

    private static String keyFor(String s) {
        return "metrics:src/" + s;
    }
}

