/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.python.it.plugin;

import com.sonar.orchestrator.build.BuildResult;
import com.sonar.python.it.ConcurrentOrchestratorExtension;
import com.sonar.python.it.TestsUtils;
import java.io.File;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class PylintReportTest {
    private static final String DEFAULT_PROPERTY = "sonar.python.pylint.reportPaths";
    private static final String LEGACY_PROPERTY = "sonar.python.pylint.reportPath";
    @RegisterExtension
    public static final ConcurrentOrchestratorExtension ORCHESTRATOR = TestsUtils.dynamicOrchestrator;

    @Test
    void import_report() {
        String projectKey = "pylint_project";
        PylintReportTest.analyseProjectWithReport("pylint_project", DEFAULT_PROPERTY, "pylint-report.txt");
        Assertions.assertThat((List)TestsUtils.issues((String)"pylint_project")).hasSize(4);
    }

    @Test
    void import_report_legacy_key() {
        String projectKey = "pylint_project_legacy_key";
        PylintReportTest.analyseProjectWithReport("pylint_project_legacy_key", LEGACY_PROPERTY, "pylint-report.txt");
        Assertions.assertThat((List)TestsUtils.issues((String)"pylint_project_legacy_key")).hasSize(4);
    }

    @Test
    void missing_report() {
        String projectKey = "pylint_project_missing_report";
        PylintReportTest.analyseProjectWithReport("pylint_project_missing_report", DEFAULT_PROPERTY, "missing");
        Assertions.assertThat((List)TestsUtils.issues((String)"pylint_project_missing_report")).isEmpty();
    }

    @Test
    void invalid_report() {
        String projectKey = "pylint_project_invalid_report";
        BuildResult result = PylintReportTest.analyseProjectWithReport("pylint_project_invalid_report", DEFAULT_PROPERTY, "invalid.txt");
        Assertions.assertThat((String)result.getLogs()).contains(new CharSequence[]{"Cannot parse the line: trash"});
        Assertions.assertThat((List)TestsUtils.issues((String)"pylint_project_invalid_report")).isEmpty();
    }

    @Test
    void unknown_rule() {
        String projectKey = "pylint_project_unknown_rule";
        PylintReportTest.analyseProjectWithReport("pylint_project_unknown_rule", DEFAULT_PROPERTY, "rule-unknown.txt");
        Assertions.assertThat((List)TestsUtils.issues((String)"pylint_project_unknown_rule")).hasSize(4);
    }

    @Test
    void multiple_reports() {
        String projectKey = "pylint_project_multiple_reports";
        PylintReportTest.analyseProjectWithReport("pylint_project_multiple_reports", DEFAULT_PROPERTY, "pylint-report.txt, rule-unknown.txt");
        Assertions.assertThat((List)TestsUtils.issues((String)"pylint_project_multiple_reports")).hasSize(8);
    }

    private static BuildResult analyseProjectWithReport(String projectKey, String property, String reportPaths) {
        ORCHESTRATOR.getServer().provisionProject(projectKey, projectKey);
        ORCHESTRATOR.getServer().associateProjectToQualityProfile(projectKey, "py", "no_rule");
        return ORCHESTRATOR.executeBuild(ORCHESTRATOR.createSonarScanner().setDebugLogs(true).setProjectKey(projectKey).setProjectName(projectKey).setProjectDir(new File("projects/pylint_project")).setProperty(property, reportPaths));
    }
}

