/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.python.it.plugin;

import com.sonar.orchestrator.build.Build;
import com.sonar.orchestrator.build.SonarScanner;
import com.sonar.python.it.ConcurrentOrchestratorExtension;
import com.sonar.python.it.TestsUtils;
import java.io.File;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class CPDTest {
    private static final String PROJECT_KEY = "cpd";
    private static final String FILE_1_KEY = "cpd:file1.py";
    private static final String FILE_2_KEY = "cpd:file2.py";
    private static final String FILE_3_KEY = "cpd:file3.py";
    private static final String DUPLICATED_LINES = "duplicated_lines";
    private static final String DUPLICATED_BLOCKS = "duplicated_blocks";
    private static final String DUPLICATED_FILES = "duplicated_files";
    private static final String DUPLICATED_LINES_DENSITY = "duplicated_lines_density";
    @RegisterExtension
    public static final ConcurrentOrchestratorExtension ORCHESTRATOR = TestsUtils.dynamicOrchestrator;

    @BeforeAll
    static void startServer() {
        ORCHESTRATOR.getServer().provisionProject(PROJECT_KEY, PROJECT_KEY);
        ORCHESTRATOR.getServer().associateProjectToQualityProfile(PROJECT_KEY, "py", "no_rule");
        SonarScanner build = ORCHESTRATOR.createSonarScanner().setProjectDir(new File("projects/cpd")).setProjectKey(PROJECT_KEY).setProjectName(PROJECT_KEY).setProjectVersion("1.0-SNAPSHOT").setSourceDirs(".").setSourceEncoding("UTF-8");
        ORCHESTRATOR.executeBuild((Build)build);
    }

    @Test
    void test_cpd() {
        Offset offset = Offset.offset((Number)0.01);
        Assertions.assertThat((Double)TestsUtils.getMeasureAsDouble((String)FILE_1_KEY, (String)DUPLICATED_LINES)).isEqualTo(27.0, offset);
        Assertions.assertThat((Double)TestsUtils.getMeasureAsDouble((String)FILE_1_KEY, (String)DUPLICATED_BLOCKS)).isEqualTo(1.0, offset);
        Assertions.assertThat((Double)TestsUtils.getMeasureAsDouble((String)FILE_1_KEY, (String)DUPLICATED_FILES)).isEqualTo(1.0, offset);
        Assertions.assertThat((Double)TestsUtils.getMeasureAsDouble((String)FILE_1_KEY, (String)DUPLICATED_LINES_DENSITY)).isEqualTo(93.1, offset);
        Assertions.assertThat((Double)TestsUtils.getMeasureAsDouble((String)FILE_2_KEY, (String)DUPLICATED_LINES)).isEqualTo(27.0, offset);
        Assertions.assertThat((Double)TestsUtils.getMeasureAsDouble((String)FILE_2_KEY, (String)DUPLICATED_BLOCKS)).isEqualTo(1.0, offset);
        Assertions.assertThat((Double)TestsUtils.getMeasureAsDouble((String)FILE_2_KEY, (String)DUPLICATED_FILES)).isEqualTo(1.0, offset);
        Assertions.assertThat((Double)TestsUtils.getMeasureAsDouble((String)FILE_2_KEY, (String)DUPLICATED_LINES_DENSITY)).isEqualTo(90.0, offset);
        Assertions.assertThat((Double)TestsUtils.getMeasureAsDouble((String)FILE_3_KEY, (String)DUPLICATED_LINES)).isEqualTo(0.0, offset);
        Assertions.assertThat((Double)TestsUtils.getMeasureAsDouble((String)FILE_3_KEY, (String)DUPLICATED_BLOCKS)).isEqualTo(0.0, offset);
        Assertions.assertThat((Double)TestsUtils.getMeasureAsDouble((String)FILE_3_KEY, (String)DUPLICATED_FILES)).isEqualTo(0.0, offset);
        Assertions.assertThat((Double)TestsUtils.getMeasureAsDouble((String)FILE_3_KEY, (String)DUPLICATED_LINES_DENSITY)).isEqualTo(0.0, offset);
        Assertions.assertThat((Double)TestsUtils.getMeasureAsDouble((String)PROJECT_KEY, (String)DUPLICATED_LINES)).isEqualTo(54.0, offset);
        Assertions.assertThat((Double)TestsUtils.getMeasureAsDouble((String)PROJECT_KEY, (String)DUPLICATED_BLOCKS)).isEqualTo(2.0, offset);
        Assertions.assertThat((Double)TestsUtils.getMeasureAsDouble((String)PROJECT_KEY, (String)DUPLICATED_FILES)).isEqualTo(2.0, offset);
        Assertions.assertThat((Double)TestsUtils.getMeasureAsDouble((String)PROJECT_KEY, (String)DUPLICATED_LINES_DENSITY)).isEqualTo(61.4, offset);
    }
}

