/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.python.it.plugin;

import com.sonar.python.it.PluginLocator;
import com.sonar.python.it.TestsUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonarsource.sonarlint.core.analysis.AnalysisEngine;
import org.sonarsource.sonarlint.core.analysis.api.ActiveRule;
import org.sonarsource.sonarlint.core.analysis.api.AnalysisConfiguration;
import org.sonarsource.sonarlint.core.analysis.api.AnalysisEngineConfiguration;
import org.sonarsource.sonarlint.core.analysis.api.ClientInputFile;
import org.sonarsource.sonarlint.core.analysis.api.ClientModuleFileSystem;
import org.sonarsource.sonarlint.core.analysis.api.ClientModuleInfo;
import org.sonarsource.sonarlint.core.analysis.command.AnalyzeCommand;
import org.sonarsource.sonarlint.core.analysis.command.Command;
import org.sonarsource.sonarlint.core.analysis.command.RegisterModuleCommand;
import org.sonarsource.sonarlint.core.commons.api.SonarLanguage;
import org.sonarsource.sonarlint.core.commons.log.LogOutput;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;
import org.sonarsource.sonarlint.core.plugin.commons.PluginsLoadResult;
import org.sonarsource.sonarlint.core.plugin.commons.PluginsLoader;

public class SonarLintTest {
    @TempDir
    public static Path temp;
    private static AnalysisEngine sonarlintEngine;
    private final ProgressMonitor progressMonitor = new ProgressMonitor(null);
    private static File baseDir;

    @BeforeAll
    static void prepare() {
        AnalysisEngineConfiguration sonarLintConfig = AnalysisEngineConfiguration.builder().setWorkDir(temp).build();
        LogOutput logOutput = new LogOutput(){

            public void log(String formattedMessage, LogOutput.Level level, @Nullable String stacktrace) {
            }
        };
        SonarLintLogger.setTarget((LogOutput)logOutput);
        Set<Path> pluginJarLocation = Set.of(TestsUtils.dynamicOrchestrator.getConfiguration().locators().locate(PluginLocator.Plugins.PYTHON.get(PluginLocator.isEnterpriseTest())).toPath());
        Set<SonarLanguage> enabledLanguages = Set.of(SonarLanguage.PYTHON);
        PluginsLoader.Configuration pluginConfiguration = new PluginsLoader.Configuration(pluginJarLocation, enabledLanguages, false, Optional.empty());
        PluginsLoadResult pluginLoader = new PluginsLoader().load(pluginConfiguration, Set.of());
        sonarlintEngine = new AnalysisEngine(sonarLintConfig, pluginLoader.getLoadedPlugins(), logOutput);
        baseDir = temp.toFile();
    }

    @AfterAll
    static void stop() {
        SonarLintLogger.setTarget(null);
        sonarlintEngine.stop();
    }

    @Test
    void should_raise_issues() throws IOException, InterruptedException, ExecutionException {
        final ClientInputFile inputFile = SonarLintTest.prepareInputFile("foo.py", "def fooBar():\n  `1`\n  `1` #NOSONAR\n", false);
        ArrayList issues = new ArrayList();
        AnalysisConfiguration configuration = AnalysisConfiguration.builder().setBaseDir(baseDir.toPath()).addInputFile(inputFile).addActiveRules(new ActiveRule[]{new ActiveRule("python:S1542", SonarLanguage.PYTHON.name()), new ActiveRule("python:BackticksUsage", SonarLanguage.PYTHON.name())}).build();
        final EnumMap logsByLevel = new EnumMap(LogOutput.Level.class);
        LogOutput logOutput = new LogOutput(){

            public void log(String formattedMessage, LogOutput.Level level, @Nullable String stacktrace) {
                logsByLevel.computeIfAbsent(level, k -> new ArrayList()).add(formattedMessage);
            }
        };
        ClientModuleFileSystem clientFileSystem = new ClientModuleFileSystem(){

            public Stream<ClientInputFile> files(String s, InputFile.Type type) {
                return Stream.of(inputFile);
            }

            public Stream<ClientInputFile> files() {
                return Stream.of(inputFile);
            }
        };
        sonarlintEngine.post((Command)new RegisterModuleCommand(new ClientModuleInfo((Object)"myModule", clientFileSystem)), this.progressMonitor).get();
        AnalyzeCommand command = new AnalyzeCommand((Object)"myModule", configuration, issues::add, logOutput);
        sonarlintEngine.post((Command)command, this.progressMonitor).get();
        Assertions.assertThat((List)((List)logsByLevel.get(LogOutput.Level.WARN))).containsExactly((Object[])new String[]{"No workDir in SonarLint"});
        Assertions.assertThat(issues).extracting(new String[]{"ruleKey", "textRange.startLine", "inputFile.path"}).containsOnly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"python:BackticksUsage", 2, inputFile.uri().getPath()}), Assertions.tuple((Object[])new Object[]{"python:S1542", 1, inputFile.uri().getPath()})});
    }

    private static ClientInputFile prepareInputFile(String relativePath, String content, boolean isTest) throws IOException {
        File file = new File(baseDir, relativePath);
        FileUtils.write((File)file, (CharSequence)content, (Charset)StandardCharsets.UTF_8);
        return SonarLintTest.createInputFile(file.toPath(), relativePath, isTest);
    }

    private static ClientInputFile createInputFile(final Path path, final String relativePath, final boolean isTest) {
        return new ClientInputFile(){

            public String getPath() {
                return path.toString();
            }

            public boolean isTest() {
                return isTest;
            }

            public Charset getCharset() {
                return StandardCharsets.UTF_8;
            }

            public <G> G getClientObject() {
                return null;
            }

            public InputStream inputStream() throws IOException {
                return Files.newInputStream(path, new OpenOption[0]);
            }

            public String contents() throws IOException {
                return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
            }

            public String relativePath() {
                return relativePath;
            }

            public URI uri() {
                return path.toUri();
            }
        };
    }
}

