/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.python.it.plugin;

import com.sonar.orchestrator.build.Build;
import com.sonar.python.it.ConcurrentOrchestratorExtension;
import com.sonar.python.it.TestsUtils;
import java.io.File;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Issues;

public class MypyReportTest {
    private static final String PROJECT = "mypy_project";
    @RegisterExtension
    public static final ConcurrentOrchestratorExtension ORCHESTRATOR = TestsUtils.dynamicOrchestrator;

    @Test
    void import_report() {
        ORCHESTRATOR.getServer().provisionProject(PROJECT, PROJECT);
        ORCHESTRATOR.getServer().associateProjectToQualityProfile(PROJECT, "py", "no_rule");
        ORCHESTRATOR.executeBuild((Build)ORCHESTRATOR.createSonarScanner().setProjectDir(new File("projects/mypy_project")));
        List issues = TestsUtils.issues((String)PROJECT);
        Assertions.assertThat((List)issues).hasSize(5);
        MypyReportTest.assertIssue((Issues.Issue)issues.get(0), "external_mypy:arg-type", "Argument 1 to \"greet_all\" has incompatible type \"List[int]\"; expected \"List[str]\"");
        MypyReportTest.assertIssue((Issues.Issue)issues.get(1), "external_mypy:no-untyped-def", "Function is missing a type annotation");
        MypyReportTest.assertIssue((Issues.Issue)issues.get(2), "external_mypy:import", "Cannot find implementation or library stub for module named \"unknown\"");
        MypyReportTest.assertIssue((Issues.Issue)issues.get(3), "external_mypy:no-untyped-call", "Call to untyped function \"no_type_hints\" in typed context");
        MypyReportTest.assertIssue((Issues.Issue)issues.get(4), "external_mypy:unknown_mypy_rule", "Unused \"type: ignore\" comment");
    }

    private static void assertIssue(Issues.Issue issue, String rule, String message) {
        Assertions.assertThat((String)issue.getComponent()).isEqualTo("mypy_project:src/type_hints_noncompliant.py");
        Assertions.assertThat((String)issue.getRule()).isEqualTo(rule);
        Assertions.assertThat((String)issue.getMessage()).isEqualTo(message);
        Assertions.assertThat((Comparable)issue.getType()).isEqualTo((Object)Common.RuleType.CODE_SMELL);
        Assertions.assertThat((Comparable)issue.getSeverity()).isEqualTo((Object)Common.Severity.MAJOR);
        Assertions.assertThat((String)issue.getEffort()).isEqualTo("5min");
    }
}

