/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.python.it.plugin;

import com.sonar.orchestrator.build.Build;
import com.sonar.python.it.ConcurrentOrchestratorExtension;
import com.sonar.python.it.TestsUtils;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Issues;

class RuffReportTest {
    private static final String PROJECT = "ruff_project";
    @RegisterExtension
    public static final ConcurrentOrchestratorExtension ORCHESTRATOR = TestsUtils.dynamicOrchestrator;

    RuffReportTest() {
    }

    @Test
    void import_report() {
        ORCHESTRATOR.getServer().provisionProject(PROJECT, PROJECT);
        ORCHESTRATOR.getServer().associateProjectToQualityProfile(PROJECT, "py", "no_rule");
        ORCHESTRATOR.executeBuild((Build)ORCHESTRATOR.createSonarScanner().setProjectDir(new File("projects/ruff_project")));
        List<Issues.Issue> issues = TestsUtils.issues((String)PROJECT).stream().sorted(Comparator.comparing(Issues.Issue::getRule)).toList();
        Assertions.assertThat(issues).hasSize(2);
        Issues.Issue firstIssue = issues.get(0);
        Assertions.assertThat((String)firstIssue.getComponent()).isEqualTo("ruff_project:src/file1.py");
        Assertions.assertThat((String)firstIssue.getRule()).isEqualTo("external_ruff:E501");
        Assertions.assertThat((String)firstIssue.getMessage()).isEqualTo("Line too long (108 > 88 characters)");
        Assertions.assertThat((Comparable)firstIssue.getType()).isEqualTo((Object)Common.RuleType.CODE_SMELL);
        Assertions.assertThat((Comparable)firstIssue.getSeverity()).isEqualTo((Object)Common.Severity.MAJOR);
        Assertions.assertThat((String)firstIssue.getEffort()).isEqualTo("5min");
        Issues.Issue secondIssue = issues.get(1);
        Assertions.assertThat((String)secondIssue.getComponent()).isEqualTo("ruff_project:src/file1.py");
        Assertions.assertThat((String)secondIssue.getRule()).isEqualTo("external_ruff:F821");
        Assertions.assertThat((String)secondIssue.getMessage()).isEqualTo("Undefined name `random`");
        Assertions.assertThat((Comparable)secondIssue.getType()).isEqualTo((Object)Common.RuleType.CODE_SMELL);
        Assertions.assertThat((Comparable)secondIssue.getSeverity()).isEqualTo((Object)Common.Severity.MAJOR);
        Assertions.assertThat((String)secondIssue.getEffort()).isEqualTo("5min");
    }
}

