/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.python.it.plugin;

import com.sonar.python.it.PluginLocator;
import com.sonar.python.it.TestsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonarsource.sonarlint.core.analysis.AnalysisEngine;
import org.sonarsource.sonarlint.core.analysis.api.ActiveRule;
import org.sonarsource.sonarlint.core.analysis.api.AnalysisConfiguration;
import org.sonarsource.sonarlint.core.analysis.api.AnalysisEngineConfiguration;
import org.sonarsource.sonarlint.core.analysis.api.ClientInputFile;
import org.sonarsource.sonarlint.core.analysis.api.ClientModuleFileSystem;
import org.sonarsource.sonarlint.core.analysis.api.ClientModuleInfo;
import org.sonarsource.sonarlint.core.analysis.api.Issue;
import org.sonarsource.sonarlint.core.analysis.api.WithTextRange;
import org.sonarsource.sonarlint.core.analysis.command.AnalyzeCommand;
import org.sonarsource.sonarlint.core.analysis.command.Command;
import org.sonarsource.sonarlint.core.analysis.command.RegisterModuleCommand;
import org.sonarsource.sonarlint.core.commons.api.SonarLanguage;
import org.sonarsource.sonarlint.core.commons.log.LogOutput;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;
import org.sonarsource.sonarlint.core.plugin.commons.PluginsLoadResult;
import org.sonarsource.sonarlint.core.plugin.commons.PluginsLoader;

public class SonarLintIPythonTest {
    @TempDir
    public static Path temp;
    private static AnalysisEngine sonarlintEngine;
    private final ProgressMonitor progressMonitor = new ProgressMonitor(null);

    @BeforeAll
    static void prepare() {
        AnalysisEngineConfiguration sonarLintConfig = AnalysisEngineConfiguration.builder().setWorkDir(temp).build();
        LogOutput logOutput = new LogOutput(){

            public void log(String formattedMessage, LogOutput.Level level, @Nullable String stacktrace) {
            }
        };
        SonarLintLogger.setTarget((LogOutput)logOutput);
        Set<Path> pluginJarLocation = Set.of(TestsUtils.dynamicOrchestrator.getConfiguration().locators().locate(PluginLocator.pythonPluginLocation()).toPath());
        Set<SonarLanguage> enabledLanguages = Set.of(SonarLanguage.IPYTHON);
        PluginsLoader.Configuration pluginConfiguration = new PluginsLoader.Configuration(pluginJarLocation, enabledLanguages, false, Optional.empty());
        PluginsLoadResult pluginLoader = new PluginsLoader().load(pluginConfiguration, Set.of());
        sonarlintEngine = new AnalysisEngine(sonarLintConfig, pluginLoader.getLoadedPlugins(), logOutput);
    }

    @AfterAll
    static void stop() {
        SonarLintLogger.setTarget(null);
        sonarlintEngine.stop();
    }

    @Test
    void shouldRaiseIssues() throws InterruptedException, ExecutionException {
        ClientInputFile inputFile = SonarLintIPythonTest.createInputFile(Path.of("projects/ipynb_project/file1.ipynb", new String[0]), "file1.ipynb", false);
        ArrayList issues = new ArrayList();
        AnalysisConfiguration configuration = AnalysisConfiguration.builder().setBaseDir(Path.of("projects/ipynb_project", new String[0])).addInputFile(inputFile).addActiveRules(new ActiveRule[]{new ActiveRule("ipython:PrintStatementUsage", SonarLanguage.IPYTHON.name()), new ActiveRule("ipython:S1172", SonarLanguage.IPYTHON.name()), new ActiveRule("ipython:S930", SonarLanguage.IPYTHON.name()), new ActiveRule("ipython:S1542", SonarLanguage.IPYTHON.name()), new ActiveRule("ipython:BackticksUsage", SonarLanguage.IPYTHON.name())}).build();
        HashMap<LogOutput.Level, List<String>> logsByLevel = new HashMap<LogOutput.Level, List<String>>();
        LogOutput logOutput = SonarLintIPythonTest.createClientLogOutput(logsByLevel);
        ClientModuleFileSystem clientFileSystem = SonarLintIPythonTest.createClientFileSystem(inputFile);
        sonarlintEngine.post((Command)new RegisterModuleCommand(new ClientModuleInfo((Object)"myModule", clientFileSystem)), this.progressMonitor).get();
        AnalyzeCommand command = new AnalyzeCommand((Object)"myModule", configuration, issues::add, logOutput);
        sonarlintEngine.post((Command)command, this.progressMonitor).get();
        Assertions.assertThat(issues).extracting(new Function[]{Issue::getRuleKey, WithTextRange::getStartLine, i -> i.getInputFile().uri()}).containsOnly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"ipython:PrintStatementUsage", 32, inputFile.uri()}), Assertions.tuple((Object[])new Object[]{"ipython:S1172", 40, inputFile.uri()}), Assertions.tuple((Object[])new Object[]{"ipython:S930", 41, inputFile.uri()}), Assertions.tuple((Object[])new Object[]{"ipython:S1172", 42, inputFile.uri()}), Assertions.tuple((Object[])new Object[]{"ipython:S1542", 57, inputFile.uri()}), Assertions.tuple((Object[])new Object[]{"ipython:BackticksUsage", 58, inputFile.uri()})});
    }

    private static LogOutput createClientLogOutput(final Map<LogOutput.Level, List<String>> logsByLevel) {
        return new LogOutput(){

            public void log(String formattedMessage, LogOutput.Level level, @Nullable String stacktrace) {
                logsByLevel.computeIfAbsent(level, k -> new ArrayList()).add(formattedMessage);
            }
        };
    }

    private static ClientModuleFileSystem createClientFileSystem(final ClientInputFile ... inputFiles) {
        return new ClientModuleFileSystem(){

            public Stream<ClientInputFile> files(String s, InputFile.Type type) {
                return Stream.of(inputFiles);
            }

            public Stream<ClientInputFile> files() {
                return Stream.of(inputFiles);
            }
        };
    }

    private static ClientInputFile createInputFile(final Path path, final String relativePath, final boolean isTest) {
        return new ClientInputFile(){

            public String getPath() {
                return path.toString();
            }

            public boolean isTest() {
                return isTest;
            }

            public Charset getCharset() {
                return StandardCharsets.UTF_8;
            }

            public <G> G getClientObject() {
                return null;
            }

            public InputStream inputStream() throws IOException {
                return Files.newInputStream(path, new OpenOption[0]);
            }

            public String contents() throws IOException {
                return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
            }

            public String relativePath() {
                return relativePath;
            }

            public URI uri() {
                return path.toUri();
            }
        };
    }
}

