/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.python.it.plugin;

import com.sonar.orchestrator.build.Build;
import com.sonar.orchestrator.build.SonarScanner;
import com.sonar.python.it.ConcurrentOrchestratorExtension;
import com.sonar.python.it.TestsUtils;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.sonarqube.ws.Issues;
import org.sonarqube.ws.client.issues.SearchRequest;

public class TestRulesTest {
    @RegisterExtension
    public static final ConcurrentOrchestratorExtension orchestrator = TestsUtils.dynamicOrchestrator;
    private static final String PROJECT_KEY = "test-rules";
    private static final String PROJECT_NAME = "Test Rules";
    private static SonarScanner BUILD;

    @BeforeAll
    static void prepare() {
        orchestrator.getServer().provisionProject(PROJECT_KEY, PROJECT_NAME);
        orchestrator.getServer().associateProjectToQualityProfile(PROJECT_KEY, "py", "python-test-rules-profile");
        BUILD = orchestrator.createSonarScanner().setProjectDir(new File("projects/test_code")).setProjectKey(PROJECT_KEY).setProjectName(PROJECT_NAME).setProjectVersion("1.0");
    }

    @Test
    void test_rules_run_on_test_files() {
        BUILD.setSourceDirs("src").setTestDirs("tests");
        orchestrator.executeBuild((Build)BUILD);
        List<Issues.Issue> assertOnTupleIssues = TestRulesTest.issues("python:S5905");
        List<Issues.Issue> dedicatedAssertionIssues = TestRulesTest.issues("python:S5906");
        List<Issues.Issue> mainRuleIssues = TestRulesTest.issues("python:S3923");
        Assertions.assertThat(assertOnTupleIssues).hasSize(2);
        Assertions.assertThat(dedicatedAssertionIssues).hasSize(1);
        Assertions.assertThat(mainRuleIssues).hasSize(1);
        this.assertIssue(assertOnTupleIssues.get(0), 2, "Fix this assertion on a tuple literal.", "test-rules:src/some_code.py");
        this.assertIssue(assertOnTupleIssues.get(1), 3, "Fix this assertion on a tuple literal.", "test-rules:tests/test_my_code.py");
        this.assertIssue(dedicatedAssertionIssues.get(0), 14, "Consider using \"assertEqual\" instead.", "test-rules:tests/test_my_code.py");
        this.assertIssue(mainRuleIssues.get(0), 3, "Remove this if statement or edit its code blocks so that they're not all the same.", "test-rules:src/some_code.py");
    }

    @Test
    void declare_all_files_as_test_files() {
        BUILD.setTestDirs(".");
        orchestrator.executeBuild((Build)BUILD);
        List<Issues.Issue> testRuleIssues = TestRulesTest.issues("python:S5905");
        List<Issues.Issue> mainRuleIssues = TestRulesTest.issues("python:S3923");
        Assertions.assertThat(testRuleIssues).hasSize(2);
        Assertions.assertThat(mainRuleIssues).isEmpty();
    }

    private void assertIssue(Issues.Issue issue, int expectedLine, String expectedMessage, String expectedComponent) {
        Assertions.assertThat((int)issue.getLine()).isEqualTo(expectedLine);
        Assertions.assertThat((String)issue.getMessage()).isEqualTo(expectedMessage);
        Assertions.assertThat((String)issue.getComponent()).isEqualTo(expectedComponent);
    }

    private static List<Issues.Issue> issues(String rulekey) {
        return TestsUtils.newWsClient().issues().search(new SearchRequest().setRules(Collections.singletonList(rulekey))).getIssuesList();
    }
}

