/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.python.it.plugin;

import com.sonar.orchestrator.build.Build;
import com.sonar.orchestrator.build.SonarScanner;
import com.sonar.python.it.ConcurrentOrchestratorExtension;
import com.sonar.python.it.TestsUtils;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.sonarqube.ws.Issues;
import org.sonarqube.ws.client.issues.SearchRequest;

@ResourceLock(value="project/custom_rules")
public class CustomRulesExampleTest {
    @RegisterExtension
    public static final ConcurrentOrchestratorExtension orchestrator = TestsUtils.dynamicOrchestrator;
    private static final String PROJECT_KEY = "custom-rules-example";
    private static final String PROJECT_NAME = "Custom Rules Example";

    @BeforeAll
    static void prepare() {
        orchestrator.getServer().provisionProject(PROJECT_KEY, PROJECT_NAME);
        orchestrator.getServer().associateProjectToQualityProfile(PROJECT_KEY, "py", "python-custom-rules-example-profile");
        SonarScanner build = orchestrator.createSonarScanner().setProjectDir(new File("projects/custom_rules")).setProjectKey(PROJECT_KEY).setProjectName(PROJECT_NAME).setProjectVersion("1.0").setSourceDirs("src");
        orchestrator.executeBuild((Build)build);
    }

    @Test
    void base_tree_visitor_check() {
        List<Issues.Issue> issues = CustomRulesExampleTest.issues("python-custom-rules-example:visitor");
        this.assertSingleIssue(issues, 4, "Function def.", "5min");
    }

    @Test
    void subscription_base_visitor_check() {
        List<Issues.Issue> issues = CustomRulesExampleTest.issues("python-custom-rules-example:subscription");
        this.assertSingleIssue(issues, 7, "For statement.", "10min");
    }

    private void assertSingleIssue(List<Issues.Issue> issues, int expectedLine, String expectedMessage, String expectedDebt) {
        Assertions.assertThat(issues).hasSize(1);
        Issues.Issue issue = issues.get(0);
        Assertions.assertThat((int)issue.getLine()).isEqualTo(expectedLine);
        Assertions.assertThat((String)issue.getMessage()).isEqualTo(expectedMessage);
        Assertions.assertThat((String)issue.getDebt()).isEqualTo(expectedDebt);
    }

    private static List<Issues.Issue> issues(String rulekey) {
        return TestsUtils.newWsClient().issues().search(new SearchRequest().setRules(Collections.singletonList(rulekey))).getIssuesList();
    }
}

