/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.python.it.plugin;

import com.google.common.collect.ImmutableMap;
import com.sonar.orchestrator.build.Build;
import com.sonar.orchestrator.build.BuildResult;
import com.sonar.orchestrator.build.SonarScanner;
import com.sonar.python.it.ConcurrentOrchestratorExtension;
import com.sonar.python.it.TestsUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class CoverageTest {
    private static final String COVERAGE_PROJECT = "projects/coverage_project";
    @RegisterExtension
    public static final ConcurrentOrchestratorExtension ORCHESTRATOR = TestsUtils.dynamicOrchestrator;
    private static final String PROJECT_KEY = "coverage_project";
    private static final String LINES_TO_COVER = "lines_to_cover";
    private static final String COVERAGE = "coverage";
    private static final String LINE_COVERAGE = "line_coverage";
    private static final String BRANCH_COVERAGE = "branch_coverage";
    private static final String EMPTY_XML = "empty.xml";
    private static final String DEPRECATED_COVERAGE_REPORT_PATH = "sonar.python.coverage.reportPath";
    private static final String COVERAGE_REPORT_PATHS = "sonar.python.coverage.reportPaths";

    @Test
    void basic_coverage_reports_with_unix_paths() {
        CoverageTest.basicCoverageReports("ut-coverage.xml");
    }

    @Test
    void basic_coverage_reports_with_windows_paths() {
        CoverageTest.basicCoverageReports("ut-coverage-windowspaths.xml");
    }

    private static void basicCoverageReports(String utReportPath) {
        SonarScanner build = (SonarScanner)((SonarScanner)ORCHESTRATOR.createSonarScanner().setProjectDir(new File(COVERAGE_PROJECT)).setProperty(DEPRECATED_COVERAGE_REPORT_PATH, "someReport")).setProperty(COVERAGE_REPORT_PATHS, utReportPath + ",it-coverage1.xml,it-coverage2.xml");
        BuildResult result = ORCHESTRATOR.executeBuild((Build)build);
        ImmutableMap values = new ImmutableMap.Builder().put((Object)LINES_TO_COVER, (Object)14).put((Object)COVERAGE, (Object)56).put((Object)LINE_COVERAGE, (Object)50).put((Object)BRANCH_COVERAGE, (Object)100).build();
        TestsUtils.assertProjectMeasures((String)PROJECT_KEY, (Map)values);
        Assertions.assertThat((String)result.getLogs()).contains(new CharSequence[]{"Property 'sonar.python.coverage.reportPath' has been removed. Please use 'sonar.python.coverage.reportPaths' instead."});
    }

    @Test
    void default_values() {
        SonarScanner build = ORCHESTRATOR.createSonarScanner().setProjectDir(new File(COVERAGE_PROJECT));
        ORCHESTRATOR.executeBuild((Build)build);
        ImmutableMap values = new ImmutableMap.Builder().put((Object)LINES_TO_COVER, (Object)14).put((Object)COVERAGE, (Object)25).put((Object)LINE_COVERAGE, (Object)28).put((Object)BRANCH_COVERAGE, (Object)0).build();
        TestsUtils.assertProjectMeasures((String)PROJECT_KEY, (Map)values);
    }

    @Test
    void empty_property() {
        SonarScanner build = (SonarScanner)((SonarScanner)ORCHESTRATOR.createSonarScanner().setProjectDir(new File(COVERAGE_PROJECT)).setProperty(DEPRECATED_COVERAGE_REPORT_PATH, "")).setProperty(COVERAGE_REPORT_PATHS, "");
        ORCHESTRATOR.executeBuild((Build)build);
        HashMap<String, Integer> expected = new HashMap<String, Integer>();
        expected.put(LINES_TO_COVER, 14);
        expected.put(COVERAGE, 0);
        expected.put(LINE_COVERAGE, 0);
        expected.put(BRANCH_COVERAGE, null);
        TestsUtils.assertProjectMeasures((String)PROJECT_KEY, expected);
    }

    @Test
    void empty_coverage_report() {
        SonarScanner build = (SonarScanner)((SonarScanner)ORCHESTRATOR.createSonarScanner().setProjectDir(new File(COVERAGE_PROJECT)).setProperty(DEPRECATED_COVERAGE_REPORT_PATH, EMPTY_XML)).setProperty(COVERAGE_REPORT_PATHS, EMPTY_XML);
        BuildResult buildResult = ORCHESTRATOR.executeBuild((Build)build);
        int nbLog = 0;
        for (String s : buildResult.getLogs().split("[\\r\\n]+")) {
            if (!s.matches(".*The report '[^']*' seems to be empty, ignoring.*")) continue;
            ++nbLog;
        }
        Assertions.assertThat((int)nbLog).isEqualTo(1);
        Assertions.assertThat((Double)TestsUtils.getMeasureAsDouble((String)PROJECT_KEY, (String)COVERAGE)).isZero();
    }
}

