/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.utils;

import com.google.common.base.Preconditions;
import com.sonarsource.checks.verifier.SingleFileVerifier;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Trivia;
import org.sonar.python.SubscriptionVisitor;
import org.sonar.python.TestPythonVisitorRunner;
import org.sonar.python.tree.TreeUtils;

public class PythonCheckVerifier {
    private PythonCheckVerifier() {
    }

    private static List<PythonCheck.PreciseIssue> scanFileForIssues(PythonCheck check, PythonVisitorContext context) {
        check.scanFile(context);
        if (check instanceof PythonSubscriptionCheck) {
            SubscriptionVisitor.analyze(Collections.singletonList((PythonSubscriptionCheck)check), (PythonVisitorContext)context);
        }
        return context.getIssues();
    }

    public static void verify(String path, PythonCheck check) {
        File file = new File(path);
        PythonCheckVerifier.createVerifier(file, check).assertOneOrMoreIssues();
    }

    public static void verifyNoIssue(String path, PythonCheck check) {
        File file = new File(path);
        PythonCheckVerifier.createVerifier(file, check).assertNoIssues();
    }

    private static SingleFileVerifier createVerifier(File file, PythonCheck check) {
        SingleFileVerifier verifier = SingleFileVerifier.create((Path)file.toPath(), (Charset)StandardCharsets.UTF_8);
        return PythonCheckVerifier.getSingleFileVerifier(check, verifier, file);
    }

    private static SingleFileVerifier getSingleFileVerifier(PythonCheck check, SingleFileVerifier verifier, File file) {
        PythonVisitorContext context = TestPythonVisitorRunner.createContext((File)file);
        for (PythonCheck.PreciseIssue issue : PythonCheckVerifier.scanFileForIssues(check, context)) {
            if (!issue.check().equals(check)) {
                throw new IllegalStateException("Verifier support only one kind of issue " + issue.check() + " != " + check);
            }
            Integer cost = issue.cost();
            PythonCheckVerifier.addPreciseIssue(verifier, issue).withGap(cost == null ? null : Double.valueOf(cost.intValue()));
        }
        for (Token token : TreeUtils.tokens((Tree)context.rootTree())) {
            for (Trivia trivia : token.trivia()) {
                verifier.addComment(trivia.token().line(), trivia.token().column() + 1, trivia.value(), 1, 0);
            }
        }
        return verifier;
    }

    private static SingleFileVerifier.Issue addPreciseIssue(SingleFileVerifier verifier, PythonCheck.PreciseIssue preciseIssue) {
        IssueLocation location = preciseIssue.primaryLocation();
        String message = location.message();
        Preconditions.checkNotNull((Object)message, (Object)"Primary location message should never be null.");
        if (location.startLine() == 0) {
            return verifier.reportIssue(message).onFile();
        }
        if (location.startLineOffset() == -1) {
            return verifier.reportIssue(message).onLine(location.startLine());
        }
        SingleFileVerifier.Issue issueBuilder = verifier.reportIssue(message).onRange(location.startLine(), location.startLineOffset() + 1, location.endLine(), location.endLineOffset());
        for (IssueLocation secondary : preciseIssue.secondaryLocations()) {
            issueBuilder.addSecondary(secondary.startLine(), secondary.startLineOffset() + 1, secondary.endLine(), secondary.endLineOffset(), secondary.message());
        }
        return issueBuilder;
    }
}

