/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.caching.CacheContext;
import org.sonar.plugins.python.api.project.configuration.ProjectConfiguration;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Trivia;
import org.sonar.python.SubscriptionVisitor;
import org.sonar.python.TestPythonVisitorRunner;
import org.sonar.python.caching.CacheContextImpl;
import org.sonar.python.semantic.ProjectLevelSymbolTable;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.TreeUtils;
import org.sonarsource.analyzer.commons.checks.verifier.MultiFileVerifier;

public class PythonCheckVerifier {
    private PythonCheckVerifier() {
    }

    private static List<PythonCheck.PreciseIssue> scanFileForIssues(PythonCheck check, PythonVisitorContext context) {
        check.scanFile(context);
        if (check instanceof PythonSubscriptionCheck) {
            PythonSubscriptionCheck subscriptionCheck = (PythonSubscriptionCheck)check;
            SubscriptionVisitor.analyze(Collections.singletonList(subscriptionCheck), (PythonVisitorContext)context);
        }
        return context.getIssues();
    }

    public static void verify(String path, PythonCheck check) {
        PythonCheckVerifier.verify(Collections.singletonList(path), check);
    }

    public static void verifyNoIssue(String path, PythonCheck check) {
        File file = new File(path);
        PythonCheckVerifier.createVerifier(Collections.singletonList(file), check, ProjectLevelSymbolTable.empty(), null, null).assertNoIssues();
    }

    public static void verify(List<String> paths, PythonCheck check) {
        PythonCheckVerifier.verify(paths, check, null);
    }

    public static void verify(List<String> paths, PythonCheck check, @Nullable ProjectConfiguration projectConfiguration) {
        List<File> files = paths.stream().map(File::new).toList();
        File baseDirFile = new File(files.get(0).getParent());
        ProjectLevelSymbolTable projectLevelSymbolTable = TestPythonVisitorRunner.globalSymbols(files, (File)baseDirFile);
        PythonCheckVerifier.createVerifier(files, check, projectLevelSymbolTable, baseDirFile, projectConfiguration).assertOneOrMoreIssues();
    }

    public static void verifyNoIssue(List<String> paths, PythonCheck check) {
        List<File> files = paths.stream().map(File::new).toList();
        File baseDirFile = new File(files.get(0).getParent());
        ProjectLevelSymbolTable projectLevelSymbolTable = TestPythonVisitorRunner.globalSymbols(files, (File)baseDirFile);
        PythonCheckVerifier.createVerifier(files, check, projectLevelSymbolTable, baseDirFile, null).assertNoIssues();
    }

    public static List<PythonCheck.PreciseIssue> issues(String path, PythonCheck check) {
        File file = new File(path);
        PythonVisitorContext context = PythonCheckVerifier.createContext(file, ProjectLevelSymbolTable.empty(), null, null);
        return PythonCheckVerifier.scanFileForIssues(check, context);
    }

    private static MultiFileVerifier createVerifier(List<File> files, PythonCheck check, ProjectLevelSymbolTable projectLevelSymbolTable, @Nullable File baseDir, @Nullable ProjectConfiguration projectConfiguration) {
        MultiFileVerifier multiFileVerifier = MultiFileVerifier.create((Path)files.get(0).toPath(), (Charset)StandardCharsets.UTF_8);
        for (File file : files) {
            PythonVisitorContext context = PythonCheckVerifier.createContext(file, projectLevelSymbolTable, projectConfiguration, baseDir);
            PythonCheckVerifier.addFileIssues(check, multiFileVerifier, file, context);
        }
        return multiFileVerifier;
    }

    private static PythonVisitorContext createContext(File file, ProjectLevelSymbolTable projectLevelSymbolTable, @Nullable ProjectConfiguration projectConfiguration, @Nullable File baseDir) {
        return baseDir != null ? TestPythonVisitorRunner.createContext((File)file, null, (String)SymbolUtils.pythonPackageName((File)file, (String)baseDir.getAbsolutePath()), (ProjectLevelSymbolTable)projectLevelSymbolTable, (CacheContext)CacheContextImpl.dummyCache(), (ProjectConfiguration)projectConfiguration) : TestPythonVisitorRunner.createContext((File)file, null, (ProjectConfiguration)projectConfiguration);
    }

    private static void addFileIssues(PythonCheck check, MultiFileVerifier multiFileVerifier, File file, PythonVisitorContext context) {
        for (PythonCheck.PreciseIssue issue : PythonCheckVerifier.scanFileForIssues(check, context)) {
            if (!issue.check().equals((Object)check)) {
                throw new IllegalStateException("Verifier support only one kind of issue " + String.valueOf(issue.check()) + " != " + String.valueOf(check));
            }
            Integer cost = issue.cost();
            PythonCheckVerifier.addPreciseIssue(file.toPath(), multiFileVerifier, issue).withGap(cost == null ? null : Double.valueOf(cost.intValue()));
        }
        for (Token token : TreeUtils.tokens((Tree)context.rootTree())) {
            for (Trivia trivia : token.trivia()) {
                multiFileVerifier.addComment(file.toPath(), trivia.token().line(), trivia.token().column() + 1, trivia.value(), 1, 0);
            }
        }
    }

    private static MultiFileVerifier.Issue addPreciseIssue(Path path, MultiFileVerifier verifier, PythonCheck.PreciseIssue preciseIssue) {
        IssueLocation location = preciseIssue.primaryLocation();
        String message = location.message();
        Preconditions.checkNotNull((Object)message, (Object)"Primary location message should never be null.");
        if (location.startLine() == 0) {
            return verifier.reportIssue(path, message).onFile();
        }
        if (location.startLineOffset() == -1) {
            return verifier.reportIssue(path, message).onLine(location.startLine());
        }
        MultiFileVerifier.Issue issueBuilder = verifier.reportIssue(path, message).onRange(location.startLine(), location.startLineOffset() + 1, location.endLine(), location.endLineOffset());
        for (IssueLocation secondary : preciseIssue.secondaryLocations()) {
            issueBuilder.addSecondary(path, secondary.startLine(), secondary.startLineOffset() + 1, secondary.endLine(), secondary.endLineOffset(), secondary.message());
        }
        return issueBuilder;
    }
}

