/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.quickfix;

import com.sonar.sslr.api.AstNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.sonar.api.SonarProduct;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.caching.CacheContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.python.SubscriptionVisitor;
import org.sonar.python.caching.CacheContextImpl;
import org.sonar.python.parser.PythonParser;
import org.sonar.python.semantic.ProjectLevelSymbolTable;
import org.sonar.python.tree.IPythonTreeMaker;
import org.sonar.python.tree.PythonTreeMaker;

public class PythonQuickFixVerifier {
    private PythonQuickFixVerifier() {
    }

    public static void verify(PythonCheck check, String codeWithIssue, String ... codesFixed) {
        PythonQuickFixVerifier.verify(PythonQuickFixVerifier::createPythonVisitorContext, check, false, codeWithIssue, codesFixed);
    }

    public static void verifyNoQuickFixes(PythonCheck check, String codeWithIssue) {
        PythonQuickFixVerifier.verifyNoQuickFixes(PythonQuickFixVerifier::createPythonVisitorContext, check, codeWithIssue);
    }

    public static void verifyQuickFixMessages(PythonCheck check, String codeWithIssue, String ... expectedMessages) {
        PythonQuickFixVerifier.verifyQuickFixMessages(PythonQuickFixVerifier::createPythonVisitorContext, check, codeWithIssue, expectedMessages);
    }

    public static void verifyIPython(PythonCheck check, String codeWithIssue, String ... codesFixed) {
        PythonQuickFixVerifier.verify(PythonQuickFixVerifier::createIPythonVisitorContext, check, true, codeWithIssue, codesFixed);
    }

    public static void verifyIPythonNoQuickFixes(PythonCheck check, String codeWithIssue) {
        PythonQuickFixVerifier.verifyNoQuickFixes(PythonQuickFixVerifier::createIPythonVisitorContext, check, codeWithIssue);
    }

    public static void verifyIPythonQuickFixMessages(PythonCheck check, String codeWithIssue, String ... expectedMessages) {
        PythonQuickFixVerifier.verifyQuickFixMessages(PythonQuickFixVerifier::createIPythonVisitorContext, check, codeWithIssue, expectedMessages);
    }

    public static void verify(Function<String, PythonVisitorContext> createVisitorContext, PythonCheck check, boolean isIPython, String codeWithIssue, String ... codesFixed) {
        List<PythonCheck.PreciseIssue> issues = PythonQuickFixVerifier.getIssuesWithQuickFix(createVisitorContext, check, codeWithIssue);
        ((ListAssert)((ListAssert)Assertions.assertThat(issues).as("Number of issues", new Object[0])).overridingErrorMessage("Expected 1 issue but found %d", new Object[]{issues.size()})).hasSize(1);
        PythonCheck.PreciseIssue issue = issues.get(0);
        ((ListAssert)((ListAssert)Assertions.assertThat((List)issue.quickFixes()).as("Number of quickfixes", new Object[0])).overridingErrorMessage("Expected %d quickfix but found %d", new Object[]{codesFixed.length, issue.quickFixes().size()})).hasSize(codesFixed.length);
        PythonParser pythonParser = isIPython ? PythonParser.createIPythonParser() : PythonParser.create();
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatCode(() -> pythonParser.parse(String.join((CharSequence)"\n", codesFixed))).as("Correction of quick fixes", new Object[0])).overridingErrorMessage("The code expected to be generated by the quickfix is not valid (I)Python code.\nResults is :\n%s", new Object[]{Arrays.asList(codesFixed)})).doesNotThrowAnyException();
        List<String> appliedQuickFix = issue.quickFixes().stream().map(quickFix -> PythonQuickFixVerifier.applyQuickFix(codeWithIssue, quickFix)).toList();
        ((ListAssert)Assertions.assertThat(appliedQuickFix).as("The code with the quickfix applied is not the expected result.\nApplied QuickFixes are:\n%s\nExpected result:\n%s", new Object[]{appliedQuickFix, Arrays.asList(codesFixed)})).isEqualTo(Arrays.asList(codesFixed));
    }

    public static void verifyNoQuickFixes(Function<String, PythonVisitorContext> createVisitorContext, PythonCheck check, String codeWithIssue) {
        List<PythonCheck.PreciseIssue> issues = PythonQuickFixVerifier.getIssuesWithQuickFix(createVisitorContext, check, codeWithIssue);
        ((ListAssert)((ListAssert)Assertions.assertThat(issues).as("Number of issues", new Object[0])).overridingErrorMessage("Expected 1 issue but found %d", new Object[]{issues.size()})).hasSize(1);
        PythonCheck.PreciseIssue issue = issues.get(0);
        ((ListAssert)((ListAssert)Assertions.assertThat((List)issue.quickFixes()).as("Number of quick fixes", new Object[0])).overridingErrorMessage("Expected no quick fixes for the issue but found %d", new Object[]{issue.quickFixes().size()})).isEmpty();
    }

    public static void verifyQuickFixMessages(Function<String, PythonVisitorContext> createVisitorContext, PythonCheck check, String codeWithIssue, String ... expectedMessages) {
        Stream<String> descriptions = PythonQuickFixVerifier.getIssuesWithQuickFix(createVisitorContext, check, codeWithIssue).stream().flatMap(issue -> issue.quickFixes().stream()).map(PythonQuickFix::getDescription);
        Assertions.assertThat(descriptions).containsExactly((Object[])expectedMessages);
    }

    private static List<PythonCheck.PreciseIssue> scanFileForIssues(PythonCheck check, PythonVisitorContext context) {
        check.scanFile(context);
        if (check instanceof PythonSubscriptionCheck) {
            PythonSubscriptionCheck pythonSubscriptionCheck = (PythonSubscriptionCheck)check;
            SubscriptionVisitor.analyze(Collections.singletonList(pythonSubscriptionCheck), (PythonVisitorContext)context);
        }
        return context.getIssues();
    }

    private static List<PythonCheck.PreciseIssue> getIssuesWithQuickFix(Function<String, PythonVisitorContext> createVisitorContext, PythonCheck check, String codeWithIssue) {
        PythonVisitorContext visitorContext = createVisitorContext.apply(codeWithIssue);
        return PythonQuickFixVerifier.scanFileForIssues(check, visitorContext);
    }

    private static PythonVisitorContext createPythonVisitorContext(String code) {
        return PythonQuickFixVerifier.createVisitorContext(PythonParser.create(), new PythonTreeMaker(), code);
    }

    private static PythonVisitorContext createIPythonVisitorContext(String code) {
        return PythonQuickFixVerifier.createVisitorContext(PythonParser.createIPythonParser(), (PythonTreeMaker)new IPythonTreeMaker(), code);
    }

    private static PythonVisitorContext createVisitorContext(PythonParser parser, PythonTreeMaker treeMaker, String code) {
        PythonQuickFixFile pythonFile = new PythonQuickFixFile(code);
        AstNode astNode = parser.parse(pythonFile.content());
        FileInput fileInput = treeMaker.fileInput(astNode);
        return new PythonVisitorContext(fileInput, (PythonFile)pythonFile, null, "", ProjectLevelSymbolTable.empty(), (CacheContext)CacheContextImpl.dummyCache(), SonarProduct.SONARLINT);
    }

    private static String applyQuickFix(String codeWithIssue, PythonQuickFix quickFix) {
        List<PythonTextEdit> sortedEdits = PythonQuickFixVerifier.sortTextEdits(quickFix.getTextEdits());
        String codeBeingFixed = codeWithIssue;
        for (PythonTextEdit edit : sortedEdits) {
            codeBeingFixed = PythonQuickFixVerifier.applyTextEdit(codeBeingFixed, edit);
        }
        return codeBeingFixed;
    }

    private static String applyTextEdit(String codeWithIssue, PythonTextEdit textEdit) {
        String replacement = textEdit.replacementText();
        int start = PythonQuickFixVerifier.convertPositionToIndex(codeWithIssue, textEdit.startLine(), textEdit.startLineOffset());
        int end = PythonQuickFixVerifier.convertPositionToIndex(codeWithIssue, textEdit.endLine(), textEdit.endLineOffset());
        return codeWithIssue.substring(0, start) + replacement + codeWithIssue.substring(end);
    }

    private static List<PythonTextEdit> sortTextEdits(List<PythonTextEdit> pythonTextEdits) {
        PythonQuickFixVerifier.checkNoCollision(pythonTextEdits);
        ArrayList<PythonTextEdit> list = new ArrayList<PythonTextEdit>(pythonTextEdits);
        list.sort(Comparator.comparingInt(PythonTextEdit::startLine).thenComparing(PythonTextEdit::startLineOffset));
        Collections.reverse(list);
        return Collections.unmodifiableList(list);
    }

    private static void checkNoCollision(List<PythonTextEdit> pythonTextEdits) throws IllegalArgumentException {
        for (int i = 0; i < pythonTextEdits.size(); ++i) {
            PythonTextEdit edit = pythonTextEdits.get(i);
            for (int j = i + 1; j < pythonTextEdits.size(); ++j) {
                PythonTextEdit edit2 = pythonTextEdits.get(j);
                if (!PythonQuickFixVerifier.oneEnclosedByTheOther(edit2, edit)) continue;
                throw new IllegalArgumentException("There is a collision between the range of the quickfixes.");
            }
        }
    }

    private static boolean oneEnclosedByTheOther(PythonTextEdit toCheck, PythonTextEdit reference) {
        if (PythonQuickFixVerifier.onSameLine(toCheck, reference)) {
            return toCheck.endLineOffset() >= reference.startLineOffset() && toCheck.startLineOffset() <= reference.endLineOffset();
        }
        if (PythonQuickFixVerifier.compactOnDifferentLines(toCheck, reference)) {
            return false;
        }
        if (PythonQuickFixVerifier.isCompact(toCheck)) {
            return PythonQuickFixVerifier.isSecondInFirst(toCheck, reference);
        }
        if (PythonQuickFixVerifier.isCompact(reference)) {
            return PythonQuickFixVerifier.isSecondInFirst(reference, toCheck);
        }
        if (PythonQuickFixVerifier.noLineIntersection(toCheck, reference)) {
            return false;
        }
        if (reference.startLine() == toCheck.endLine()) {
            return toCheck.endLineOffset() > reference.startLineOffset();
        }
        if (reference.endLine() == toCheck.startLine()) {
            return reference.endLineOffset() > toCheck.startLineOffset();
        }
        return true;
    }

    private static boolean onSameLine(PythonTextEdit check, PythonTextEdit ref) {
        return ref.startLine() == ref.endLine() && ref.endLine() == check.startLine() && check.startLine() == check.endLine();
    }

    private static boolean compactOnDifferentLines(PythonTextEdit check, PythonTextEdit ref) {
        return ref.startLine() == ref.endLine() && check.startLine() == check.endLine() && ref.endLine() != check.startLine();
    }

    private static boolean isCompact(PythonTextEdit check) {
        return check.startLine() == check.endLine();
    }

    private static boolean isSecondInFirst(PythonTextEdit first, PythonTextEdit second) {
        if (first.startLine() == second.startLine()) {
            return second.startLineOffset() < first.endLineOffset();
        }
        if (first.endLine() == second.endLine()) {
            return first.startLineOffset() < second.endLineOffset();
        }
        return false;
    }

    private static boolean noLineIntersection(PythonTextEdit check, PythonTextEdit ref) {
        return check.endLine() < ref.startLine() || check.startLine() > ref.endLine();
    }

    private static int convertPositionToIndex(String fileContent, int line, int lineOffset) {
        int currentIndex = 0;
        for (int currentLine = 1; currentLine < line; ++currentLine) {
            currentIndex = fileContent.indexOf("\n", currentIndex) + 1;
        }
        return currentIndex + lineOffset;
    }

    private static class PythonQuickFixFile
    implements PythonFile {
        private final String content;

        public PythonQuickFixFile(String content) {
            this.content = content;
        }

        public String content() {
            return this.content;
        }

        public String fileName() {
            return "PythonQuickFixFile";
        }

        public URI uri() {
            return URI.create(this.fileName());
        }

        public String key() {
            return "PythonQuickFixFile";
        }
    }
}

