/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.caching.CacheContext;
import org.sonar.python.TestPythonVisitorRunner;
import org.sonar.python.caching.CacheContextImpl;
import org.sonar.python.semantic.ProjectLevelSymbolTable;

public class PythonMultiFileVerifier {
    private PythonMultiFileVerifier() {
    }

    public static <R> Map<String, R> mapFiles(Map<String, String> pathToCode, String baseDir, Function<PythonVisitorContext, R> function) {
        return PythonMultiFileVerifier.mapFiles(pathToCode, baseDir, "", function);
    }

    public static <R> Map<String, R> mapFiles(Map<String, String> pathToCode, String baseDir, String packageName, Function<PythonVisitorContext, R> function) {
        Path tempDirectoryPath = PythonMultiFileVerifier.createTemporaryDirectory();
        Map<String, File> pathToFile = pathToCode.entrySet().stream().map(entry -> PythonMultiFileVerifier.writeTempFile(entry, tempDirectoryPath)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        String newBaseDir = PythonMultiFileVerifier.getNewBaseDir(baseDir, tempDirectoryPath);
        ProjectLevelSymbolTable symbolTable = TestPythonVisitorRunner.globalSymbols(pathToCode, (String)newBaseDir);
        HashMap results = new HashMap();
        pathToFile.forEach((path, file) -> {
            PythonVisitorContext context = TestPythonVisitorRunner.createContext((File)file, (File)new File(newBaseDir), (String)packageName, (ProjectLevelSymbolTable)symbolTable, (CacheContext)CacheContextImpl.dummyCache());
            results.put(path, function.apply(context));
        });
        return results;
    }

    protected static String getNewBaseDir(String baseDir, Path tempDirectoryPath) {
        return tempDirectoryPath.resolve(baseDir).toString();
    }

    static Path createTemporaryDirectory() {
        try {
            return Files.createTempDirectory("", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    static Map.Entry<String, File> writeTempFile(Map.Entry<String, String> stringStringEntry, Path tempDirectory) {
        Path newPath = tempDirectory.resolve(stringStringEntry.getKey());
        try {
            Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
            BufferedWriter fileWriter = Files.newBufferedWriter(newPath, new OpenOption[0]);
            fileWriter.write(stringStringEntry.getValue());
            fileWriter.close();
            return Map.entry(stringStringEntry.getKey(), newPath.toFile());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

