/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.stream.Collectors;

public enum PythonBuiltinFunctions {
    INSTANCE;

    private static final Set<String> BUILTINS;

    public static boolean contains(String name) {
        return BUILTINS.contains(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Set<String> loadBuiltinNames(InputStream resourceStream) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resourceStream, StandardCharsets.UTF_8));){
            Set<String> set = reader.lines().map(String::trim).filter(s -> !s.startsWith("#")).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
            return set;
        }
        catch (IOException | UncheckedIOException e) {
            throw new IllegalStateException("Cannot read input stream", e);
        }
    }

    static {
        BUILTINS = PythonBuiltinFunctions.loadBuiltinNames(PythonBuiltinFunctions.class.getResourceAsStream("builtins.txt"));
    }
}

