/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;

@Rule(key="S2711")
public class ReturnYieldOutsideFunctionCheck
extends PythonCheck {
    public static final String MESSAGE = "Remove this use of \"%s\".";
    public static final String CHECK_KEY = "S2711";

    public Set<AstNodeType> subscribedKinds() {
        return ReturnYieldOutsideFunctionCheck.immutableSet(PythonGrammar.RETURN_STMT, PythonGrammar.YIELD_STMT);
    }

    public void visitNode(AstNode node) {
        for (AstNode currentParent = node.getParent(); currentParent != null; currentParent = currentParent.getParent()) {
            if (currentParent.is(new AstNodeType[]{PythonGrammar.FUNCDEF})) {
                return;
            }
            if (!currentParent.is(new AstNodeType[]{PythonGrammar.CLASSDEF})) continue;
            this.raiseIssue(node);
            return;
        }
        this.raiseIssue(node);
    }

    private void raiseIssue(AstNode node) {
        this.addIssue(node, String.format(MESSAGE, node.getToken().getValue()));
    }
}

