/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.sslr.ast.AstSelect;

@Rule(key="S108")
public class EmptyNestedBlockCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S108";
    private static final Predicate<AstNode> NOT_PASS_PREDICATE = new NotPassPredicate();
    private static final String MESSAGE = "Either remove or fill this block of code.";

    public Set<AstNodeType> subscribedKinds() {
        return Collections.singleton(PythonGrammar.SUITE);
    }

    public void visitNode(AstNode suiteNode) {
        AstSelect nonPassSimpleStatements;
        if (suiteNode.getParent().is(new AstNodeType[]{PythonGrammar.FUNCDEF, PythonGrammar.CLASSDEF}) || EmptyNestedBlockCheck.isInExcept(suiteNode)) {
            return;
        }
        AstSelect suite = suiteNode.select();
        AstSelect stmtLists = suite.children((AstNodeType)PythonGrammar.STMT_LIST);
        if (stmtLists.isEmpty()) {
            AstSelect statementSelect = suite.children((AstNodeType)PythonGrammar.STATEMENT);
            if (statementSelect.children((AstNodeType)PythonGrammar.COMPOUND_STMT).isNotEmpty()) {
                return;
            }
            stmtLists = statementSelect.children((AstNodeType)PythonGrammar.STMT_LIST);
        }
        if ((nonPassSimpleStatements = stmtLists.children((AstNodeType)PythonGrammar.SIMPLE_STMT).children().filter(NOT_PASS_PREDICATE)).isEmpty() && !EmptyNestedBlockCheck.containsComment(suiteNode)) {
            this.addIssue(stmtLists.get(0), MESSAGE);
        }
    }

    private static boolean isInExcept(AstNode suiteNode) {
        return suiteNode.getParent().is(new AstNodeType[]{PythonGrammar.TRY_STMT}) && suiteNode.getPreviousSibling().getPreviousSibling().is(new AstNodeType[]{PythonGrammar.EXCEPT_CLAUSE});
    }

    private static boolean containsComment(AstNode suiteNode) {
        for (Token token : suiteNode.getTokens()) {
            for (Trivia trivia : token.getTrivia()) {
                if (!trivia.isComment()) continue;
                return true;
            }
        }
        return false;
    }

    private static class NotPassPredicate
    implements Predicate<AstNode> {
        private NotPassPredicate() {
        }

        @Override
        public boolean test(AstNode node) {
            return !node.getType().equals(PythonGrammar.PASS_STMT);
        }
    }
}

