/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.metrics.ComplexityVisitor;

@Rule(key="FunctionComplexity")
public class FunctionComplexityCheck
extends PythonCheck {
    private static final int DEFAULT_MAXIMUM_FUNCTION_COMPLEXITY_THRESHOLD = 15;
    private static final String MESSAGE = "Function has a complexity of %s which is greater than %s authorized.";
    @RuleProperty(key="maximumFunctionComplexityThreshold", defaultValue="15")
    int maximumFunctionComplexityThreshold = 15;

    public Set<AstNodeType> subscribedKinds() {
        return Collections.singleton(PythonGrammar.FUNCDEF);
    }

    public void visitNode(AstNode node) {
        int complexity = ComplexityVisitor.complexity((AstNode)node);
        if (complexity > this.maximumFunctionComplexityThreshold) {
            String message = String.format(MESSAGE, complexity, this.maximumFunctionComplexityThreshold);
            this.addIssue(node.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME}), message).withCost(complexity - this.maximumFunctionComplexityThreshold);
        }
    }
}

