/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.python.IssueLocation;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.checks.CheckUtils;
import org.sonar.sslr.ast.AstSelect;

@Rule(key="S1871")
public class SameBranchCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S1871";
    public static final String MESSAGE = "Either merge this branch with the identical one on line \"%s\" or change one of the implementations.";
    private static final int CONDITIONAL_EXPRESSION_SIZE = 5;
    private static final int CONDITIONAL_EXPRESSION_TRUE_BRANCH = 0;
    private static final int CONDITIONAL_EXPRESSION_IF = 1;
    private static final int CONDITIONAL_EXPRESSION_FALSE_BRANCH = 4;
    private List<AstNode> ignoreList;

    public Set<AstNodeType> subscribedKinds() {
        return SameBranchCheck.immutableSet(PythonGrammar.IF_STMT, PythonGrammar.TEST);
    }

    public void visitFile(@Nullable AstNode astNode) {
        this.ignoreList = new LinkedList<AstNode>();
    }

    public void visitNode(AstNode node) {
        if (this.ignoreList.contains(node)) {
            return;
        }
        List<AstNode> branches = node.is(new AstNodeType[]{PythonGrammar.IF_STMT}) ? this.getIfBranches(node) : this.getConditionalExpressionBranches(node);
        this.findSameBranches(branches);
    }

    private List<AstNode> getConditionalExpressionBranches(AstNode node) {
        ArrayList<AstNode> branches = new ArrayList<AstNode>();
        this.appendConditionalExpressionBranches(branches, node);
        return branches;
    }

    private void appendConditionalExpressionBranches(List<AstNode> branches, AstNode node) {
        if (node.is(new AstNodeType[]{PythonGrammar.TEST})) {
            this.ignoreList.add(node);
            List children = node.getChildren();
            if (children.size() == 1) {
                this.appendConditionalExpressionBranches(branches, (AstNode)children.get(0));
            } else if (children.size() == 5 && ((AstNode)children.get(1)).is(new AstNodeType[]{PythonKeyword.IF})) {
                this.appendConditionalExpressionBranches(branches, (AstNode)children.get(0));
                this.appendConditionalExpressionBranches(branches, (AstNode)children.get(4));
            }
        } else if (node.is(new AstNodeType[]{PythonGrammar.ATOM}) && node.getNumberOfChildren() == 3 && node.getFirstChild().is(new AstNodeType[]{PythonPunctuator.LPARENTHESIS})) {
            this.appendConditionalExpressionBranches(branches, (AstNode)node.getChildren().get(1));
        } else if (node.is(new AstNodeType[]{PythonGrammar.TESTLIST_COMP}) && node.getNumberOfChildren() == 1) {
            this.appendConditionalExpressionBranches(branches, node.getFirstChild());
        } else {
            branches.add(node);
        }
    }

    private List<AstNode> getIfBranches(AstNode ifStmt) {
        List branches = ifStmt.getChildren(new AstNodeType[]{PythonGrammar.SUITE});
        AstNode elseNode = ifStmt.getFirstChild(new AstNodeType[]{PythonKeyword.ELSE});
        if (branches.size() == 2 && elseNode != null) {
            AstNode suite = (AstNode)branches.get(1);
            this.lookForElseIfs(branches, suite);
        }
        return branches;
    }

    private void lookForElseIfs(List<AstNode> branches, AstNode suite) {
        AstNode singleIfChild = SameBranchCheck.singleIfChild(suite);
        if (singleIfChild != null) {
            this.ignoreList.add(singleIfChild);
            branches.addAll(this.getIfBranches(singleIfChild));
        }
    }

    private void findSameBranches(List<AstNode> branches) {
        for (int i = 1; i < branches.size(); ++i) {
            this.checkBranch(branches, i);
        }
    }

    private void checkBranch(List<AstNode> branches, int index) {
        AstNode duplicateBlock = branches.get(index);
        boolean isOnASingleLine = SameBranchCheck.isOnASingleLine(duplicateBlock);
        ArrayList<AstNode> equivalentBlocks = new ArrayList<AstNode>();
        for (int j = 0; j < index; ++j) {
            AstNode originalBlock = branches.get(j);
            if (CheckUtils.equalNodes(originalBlock, duplicateBlock)) {
                boolean isLastComparisonInBranches;
                equivalentBlocks.add(originalBlock);
                boolean bl = isLastComparisonInBranches = j == branches.size() - 2;
                if (isOnASingleLine && !isLastComparisonInBranches) continue;
                int line = originalBlock.getTokenLine() + (originalBlock.is(new AstNodeType[]{PythonGrammar.SUITE}) ? 1 : 0);
                String message = String.format(MESSAGE, line);
                PythonCheck.PreciseIssue issue = this.addIssue(SameBranchCheck.location(duplicateBlock, message));
                equivalentBlocks.forEach(original -> issue.secondary(SameBranchCheck.location(original, "Original")));
                return;
            }
            if (!isOnASingleLine) continue;
            return;
        }
    }

    private static IssueLocation location(AstNode node, String message) {
        AstNode firstStatement = node.getFirstChild(new AstNodeType[]{PythonGrammar.STATEMENT});
        if (firstStatement != null) {
            return IssueLocation.preciseLocation(firstStatement, SameBranchCheck.getLastNode(node), message);
        }
        return IssueLocation.preciseLocation(node, message);
    }

    private static AstNode getLastNode(AstNode node) {
        if (node.getNumberOfChildren() == 0) {
            return node;
        }
        AstNode lastChild = node.getLastChild();
        while (lastChild.is(new AstNodeType[]{PythonTokenType.NEWLINE, PythonTokenType.DEDENT, PythonTokenType.INDENT})) {
            lastChild = lastChild.getPreviousSibling();
        }
        return SameBranchCheck.getLastNode(lastChild);
    }

    private static AstNode singleIfChild(AstNode suite) {
        AstSelect nestedIf;
        List statements = suite.getChildren(new AstNodeType[]{PythonGrammar.STATEMENT});
        if (statements.size() == 1 && (nestedIf = ((AstNode)statements.get(0)).select().children((AstNodeType)PythonGrammar.COMPOUND_STMT).children((AstNodeType)PythonGrammar.IF_STMT)).size() == 1) {
            return nestedIf.get(0);
        }
        return null;
    }

    public static boolean isOnASingleLine(AstNode parent) {
        List statements = parent.getChildren(new AstNodeType[]{PythonGrammar.STATEMENT});
        if (statements.isEmpty()) {
            return true;
        }
        return ((AstNode)statements.get(0)).getTokenLine() == ((AstNode)statements.get(statements.size() - 1)).getLastToken().getLine();
    }
}

