/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.checks.AbstractCallExpressionCheck;
import org.sonar.python.semantic.Symbol;

@Rule(key="S2077")
public class SQLQueriesCheck
extends AbstractCallExpressionCheck {
    public static final String CHECK_KEY = "S2077";
    private static final String MESSAGE = "Make sure that executing SQL queries is safe here.";
    private boolean isUsingDjangoModel = false;
    private boolean isUsingDjangoDBConnection = false;

    @Override
    protected Set<String> functionsToCheck() {
        return Collections.singleton("django.db.models.expressions.RawSQL");
    }

    @Override
    protected String message() {
        return MESSAGE;
    }

    public void visitFile(AstNode node) {
        this.isUsingDjangoModel = false;
        this.isUsingDjangoDBConnection = false;
        for (Symbol symbol : this.getContext().symbolTable().symbols(node)) {
            String qualifiedName = symbol.qualifiedName();
            if (qualifiedName.contains("django.db.models")) {
                this.isUsingDjangoModel = true;
            }
            if (!qualifiedName.contains("django.db.connection")) continue;
            this.isUsingDjangoDBConnection = true;
        }
    }

    private boolean isSQLQueryFromDjangoModel(String functionName) {
        return this.isUsingDjangoModel && (functionName.equals("raw") || functionName.equals("extra"));
    }

    private boolean isSQLQueryFromDjangoDBConnection(String functionName) {
        return this.isUsingDjangoDBConnection && functionName.equals("execute");
    }

    @Override
    public void visitNode(AstNode node) {
        String functionName;
        AstNode attributeRef = node.getFirstChild(new AstNodeType[]{PythonGrammar.ATTRIBUTE_REF});
        if (attributeRef != null && (this.isSQLQueryFromDjangoModel(functionName = attributeRef.getLastChild(new AstNodeType[]{PythonGrammar.NAME}).getTokenValue()) || this.isSQLQueryFromDjangoDBConnection(functionName))) {
            this.addIssue(node, MESSAGE);
        }
        super.visitNode(node);
    }
}

