/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.checks.CheckUtils;
import org.sonar.sslr.ast.AstSelect;

@Rule(key="S1862")
public class SameConditionCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S1862";
    private static final String MESSAGE = "This branch duplicates the one on line %s.";
    private List<AstNode> ignoreList;

    public Set<AstNodeType> subscribedKinds() {
        return Collections.singleton(PythonGrammar.IF_STMT);
    }

    public void visitFile(@Nullable AstNode astNode) {
        this.ignoreList = new LinkedList<AstNode>();
    }

    public void visitNode(AstNode node) {
        if (this.ignoreList.contains(node)) {
            return;
        }
        List<AstNode> conditions = this.getConditionsToCompare(node);
        this.findSameConditions(conditions);
    }

    private List<AstNode> getConditionsToCompare(AstNode ifStmt) {
        List conditions = ifStmt.getChildren(new AstNodeType[]{PythonGrammar.TEST});
        AstNode elseNode = ifStmt.getFirstChild(new AstNodeType[]{PythonKeyword.ELSE});
        if (conditions.size() == 1 && elseNode != null) {
            AstNode suite = elseNode.getNextSibling().getNextSibling();
            this.lookForElseIfs(conditions, suite);
        }
        return conditions;
    }

    private void lookForElseIfs(List<AstNode> conditions, AstNode suite) {
        AstNode singleIfChild = SameConditionCheck.singleIfChild(suite);
        if (singleIfChild != null) {
            this.ignoreList.add(singleIfChild);
            conditions.addAll(this.getConditionsToCompare(singleIfChild));
        }
    }

    private void findSameConditions(List<AstNode> conditions) {
        for (int i = 1; i < conditions.size(); ++i) {
            this.checkCondition(conditions, i);
        }
    }

    private void checkCondition(List<AstNode> conditions, int index) {
        for (int j = 0; j < index; ++j) {
            if (!CheckUtils.equalNodes(conditions.get(j), conditions.get(index))) continue;
            String message = String.format(MESSAGE, conditions.get(j).getToken().getLine());
            this.addIssue(conditions.get(index), message).secondary(conditions.get(j), "Original");
            return;
        }
    }

    private static AstNode singleIfChild(AstNode suite) {
        AstSelect nestedIf;
        List statements = suite.getChildren(new AstNodeType[]{PythonGrammar.STATEMENT});
        if (statements.size() == 1 && (nestedIf = ((AstNode)statements.get(0)).select().children((AstNodeType)PythonGrammar.COMPOUND_STMT).children((AstNodeType)PythonGrammar.IF_STMT)).size() == 1) {
            return nestedIf.get(0);
        }
        return null;
    }
}

