/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.checks.AbstractCallExpressionCheck;
import org.sonar.python.semantic.Symbol;

@Rule(key="S4823")
public class CommandLineArgsCheck
extends AbstractCallExpressionCheck {
    public static final String CHECK_KEY = "S4823";
    private static final String MESSAGE = "Make sure that command line arguments are used safely here.";
    private static final Set<String> questionableFunctions = CommandLineArgsCheck.immutableSet("argparse.ArgumentParser", "optparse.OptionParser");

    @Override
    public Set<AstNodeType> subscribedKinds() {
        return CommandLineArgsCheck.immutableSet(PythonGrammar.CALL_EXPR, PythonGrammar.ATTRIBUTE_REF, PythonGrammar.ATOM);
    }

    @Override
    public void visitNode(AstNode node) {
        if (node.is(new AstNodeType[]{PythonGrammar.ATTRIBUTE_REF, PythonGrammar.ATOM})) {
            if (this.isSysArgvNode(node)) {
                this.addIssue(node, MESSAGE);
            }
        } else {
            super.visitNode(node);
        }
    }

    private boolean isSysArgvNode(AstNode attributeRef) {
        Symbol symbol = this.getContext().symbolTable().getSymbol(attributeRef);
        return symbol != null && symbol.qualifiedName().equals("sys.argv");
    }

    @Override
    protected Set<String> functionsToCheck() {
        return questionableFunctions;
    }

    @Override
    protected String message() {
        return MESSAGE;
    }
}

