/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.checks.AbstractCallExpressionCheck;
import org.sonar.python.semantic.Symbol;

@Rule(key="S2077")
public class SQLQueriesCheck
extends AbstractCallExpressionCheck {
    public static final String CHECK_KEY = "S2077";
    private static final String MESSAGE = "Make sure that formatting this SQL query is safe here.";
    private boolean isUsingDjangoModel = false;
    private boolean isUsingDjangoDBConnection = false;

    @Override
    protected Set<String> functionsToCheck() {
        return Collections.singleton("django.db.models.expressions.RawSQL");
    }

    @Override
    protected String message() {
        return MESSAGE;
    }

    public void visitFile(AstNode node) {
        this.isUsingDjangoModel = false;
        this.isUsingDjangoDBConnection = false;
        for (Symbol symbol : this.getContext().symbolTable().symbols(node)) {
            String qualifiedName = symbol.qualifiedName();
            if (qualifiedName.contains("django.db.models")) {
                this.isUsingDjangoModel = true;
            }
            if (!qualifiedName.contains("django.db.connection")) continue;
            this.isUsingDjangoDBConnection = true;
        }
    }

    private boolean isSQLQueryFromDjangoModel(String functionName) {
        return this.isUsingDjangoModel && (functionName.equals("raw") || functionName.equals("extra"));
    }

    private boolean isSQLQueryFromDjangoDBConnection(String functionName) {
        return this.isUsingDjangoDBConnection && functionName.equals("execute");
    }

    @Override
    public void visitNode(AstNode node) {
        String functionName;
        AstNode attributeRef = node.getFirstChild(new AstNodeType[]{PythonGrammar.ATTRIBUTE_REF});
        if (attributeRef != null && (this.isSQLQueryFromDjangoModel(functionName = attributeRef.getLastChild(new AstNodeType[]{PythonGrammar.NAME}).getTokenValue()) || this.isSQLQueryFromDjangoDBConnection(functionName)) && !this.isException(node, functionName)) {
            this.addIssue(node, MESSAGE);
        }
        super.visitNode(node);
    }

    private boolean isException(AstNode callExpression, String functionName) {
        AstNode sqlQueryNode;
        AstNode argListNode = callExpression.getFirstChild(new AstNodeType[]{PythonGrammar.ARGLIST});
        if (this.extraContainsFormattedSqlQueries(argListNode, functionName)) {
            return false;
        }
        if (argListNode != null && (sqlQueryNode = (AstNode)argListNode.getChildren().get(0)).getChildren().size() == 1 && sqlQueryNode.getFirstChild(new AstNodeType[]{PythonGrammar.TEST}) != null) {
            AstNode testNode = sqlQueryNode.getFirstChild(new AstNodeType[]{PythonGrammar.TEST});
            return !this.isFormatted(testNode);
        }
        return true;
    }

    @Override
    protected boolean isException(AstNode callExpression) {
        return this.isException(callExpression, "");
    }

    private boolean isFormatted(AstNode testNode) {
        if (testNode.getChildren().size() != 1) {
            return false;
        }
        return SQLQueriesCheck.isStrFormatCall(testNode) || SQLQueriesCheck.isFormattedStringLiteral(testNode) || testNode.getFirstChild(new AstNodeType[]{PythonGrammar.M_EXPR}) != null || testNode.getFirstChild(new AstNodeType[]{PythonGrammar.A_EXPR}) != null;
    }

    private static boolean isStrFormatCall(AstNode testNode) {
        AstNode attributeRef;
        AstNode callExpr = testNode.getFirstChild(new AstNodeType[]{PythonGrammar.CALL_EXPR});
        if (callExpr != null && (attributeRef = callExpr.getFirstChild(new AstNodeType[]{PythonGrammar.ATTRIBUTE_REF})) != null) {
            return attributeRef.getFirstChild(new AstNodeType[]{PythonGrammar.ATOM}).getFirstChild(new AstNodeType[]{PythonTokenType.STRING}) != null && attributeRef.getFirstChild(new AstNodeType[]{PythonGrammar.NAME}).getTokenValue().equals("format");
        }
        return false;
    }

    private static boolean isFormattedStringLiteral(AstNode testNode) {
        AstNode child = testNode.getFirstChild(new AstNodeType[]{PythonGrammar.ATOM});
        if (child != null) {
            AstNode string = child.getFirstChild(new AstNodeType[]{PythonTokenType.STRING});
            return string != null && (string.getTokenValue().startsWith("f") || string.getTokenValue().startsWith("F"));
        }
        return false;
    }

    private boolean extraContainsFormattedSqlQueries(@CheckForNull AstNode argListNode, String functionName) {
        if (functionName.equals("extra")) {
            return argListNode != null && argListNode.getChildren(new AstNodeType[]{PythonGrammar.ARGUMENT}).stream().filter(SQLQueriesCheck::isAssignment).map(argument -> (AstNode)argument.getChildren().get(2)).anyMatch(test -> test.getDescendants(new AstNodeType[]{PythonGrammar.TEST}).stream().anyMatch(this::isFormatted));
        }
        return false;
    }

    private static boolean isAssignment(@CheckForNull AstNode node) {
        if (node == null || node.getChildren().size() != 3) {
            return false;
        }
        return ((AstNode)node.getChildren().get(0)).is(new AstNodeType[]{PythonGrammar.TEST}) && ((AstNode)node.getChildren().get(1)).is(new AstNodeType[]{PythonPunctuator.ASSIGN}) && ((AstNode)node.getChildren().get(2)).is(new AstNodeType[]{PythonGrammar.TEST});
    }
}

