/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.xpath.api.AstNodeXPathQuery;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheck;

@Rule(key="XPath")
public class XPathCheck
extends PythonCheck {
    public static final String CHECK_KEY = "XPath";
    private static final String DEFAULT_XPATH_QUERY = "";
    private static final String DEFAULT_MESSAGE = "The XPath expression matches this piece of code";
    @RuleProperty(key="xpathQuery", defaultValue="")
    public String xpathQuery = "";
    @RuleProperty(key="message", defaultValue="The XPath expression matches this piece of code")
    public String message = "The XPath expression matches this piece of code";
    private AstNodeXPathQuery<Object> query = null;

    @CheckForNull
    private AstNodeXPathQuery<Object> query() {
        if (this.query == null && this.xpathQuery != null && !this.xpathQuery.isEmpty()) {
            try {
                this.query = AstNodeXPathQuery.create((String)this.xpathQuery);
            }
            catch (RuntimeException e) {
                throw new IllegalStateException("Unable to initialize the XPath engine, perhaps because of an invalid query: " + this.xpathQuery, e);
            }
        }
        return this.query;
    }

    public void visitFile(AstNode fileNode) {
        AstNodeXPathQuery<Object> compiledQuery = this.query();
        if (compiledQuery != null) {
            compiledQuery.selectNodes(fileNode).forEach(this::reportIssue);
        }
    }

    private void reportIssue(Object object) {
        if (object instanceof AstNode) {
            this.addIssue((AstNode)object, this.message);
        } else if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
            this.addFileIssue(this.message);
        }
    }
}

