/*
 * SonarQube Python Plugin
 * Copyright (C) 2011-2019 SonarSource SA
 * mailto:info AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.GenericTokenType;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheckAstNode;

@Rule(key = TooManyLinesInFileCheck.CHECK_KEY)
public class TooManyLinesInFileCheck extends PythonCheckAstNode {

  public static final String CHECK_KEY = "S104";
  private static final int DEFAULT = 1000;

  @RuleProperty(
    key = "maximum",
    defaultValue = "" + DEFAULT)
  public int maximum = DEFAULT;

  @Override
  public Set<AstNodeType> subscribedKinds() {
    return Collections.singleton(GenericTokenType.EOF);
  }

  @Override
  public void visitNode(AstNode astNode) {
    int lines = astNode.getTokenLine();

    if (lines > maximum) {
      String message = "File \"{0}\" has {1} lines, which is greater than {2} authorized. Split it into smaller files.";
      addFileIssue(MessageFormat.format(message, getContext().pythonFile().fileName(), lines, maximum));
    }
  }
}

