/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.RuleProperty;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.api.tree.PyFunctionDefTree;
import org.sonar.python.api.tree.PyNameTree;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.checks.AbstractNameCheck;

public abstract class AbstractFunctionNameCheck
extends AbstractNameCheck {
    private static final String DEFAULT = "^[a-z_][a-z0-9_]{2,}$";
    private static final String MESSAGE = "Rename %s \"%s\" to match the regular expression %s.";
    @RuleProperty(key="format", defaultValue="^[a-z_][a-z0-9_]{2,}$")
    public String format = "^[a-z_][a-z0-9_]{2,}$";

    @Override
    protected String format() {
        return this.format;
    }

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            PyFunctionDefTree pyFunctionDefTree = (PyFunctionDefTree)ctx.syntaxNode();
            if (!this.shouldCheckFunctionDeclaration(pyFunctionDefTree)) {
                return;
            }
            PyNameTree functionNameTree = pyFunctionDefTree.name();
            String name = functionNameTree.name();
            if (!this.pattern().matcher(name).matches()) {
                String message = String.format(MESSAGE, this.typeName(), name, this.format);
                ctx.addIssue((Tree)functionNameTree, message);
            }
        });
    }

    public abstract String typeName();

    public abstract boolean shouldCheckFunctionDeclaration(PyFunctionDefTree var1);
}

