/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.Token;
import java.util.ArrayList;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.IssueLocation;
import org.sonar.python.PythonCheck;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.api.tree.PyFunctionDefTree;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.metrics.CognitiveComplexityVisitor;

@Rule(key="S3776")
public class CognitiveComplexityFunctionCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Refactor this function to reduce its Cognitive Complexity from %s to the %s allowed.";
    public static final String CHECK_KEY = "S3776";
    private static final int DEFAULT_THRESHOLD = 15;
    @RuleProperty(key="threshold", description="The maximum authorized complexity.", defaultValue="15")
    private int threshold = 15;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            PyFunctionDefTree functionDef = (PyFunctionDefTree)ctx.syntaxNode();
            if (CognitiveComplexityFunctionCheck.isInnerFunction(functionDef)) {
                return;
            }
            ArrayList secondaryLocations = new ArrayList();
            int complexity = CognitiveComplexityVisitor.complexity((Tree)functionDef, (node, message) -> secondaryLocations.add(IssueLocation.preciseLocation((Token)node, (String)message)));
            if (complexity > this.threshold) {
                String message2 = String.format(MESSAGE, complexity, this.threshold);
                PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)functionDef.name(), message2).withCost(complexity - this.threshold);
                secondaryLocations.forEach(arg_0 -> ((PythonCheck.PreciseIssue)issue).secondary(arg_0));
            }
        });
    }

    private static boolean isInnerFunction(PyFunctionDefTree functionDef) {
        for (Tree parent = functionDef.parent(); parent != null; parent = parent.parent()) {
            if (!parent.is(Tree.Kind.FUNCDEF)) continue;
            return true;
        }
        return false;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

