/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheckTree;
import org.sonar.python.PythonVisitorContext;
import org.sonar.python.api.tree.PyIfStatementTree;
import org.sonar.python.api.tree.PyStatementTree;
import org.sonar.python.api.tree.Tree;

@Rule(key="S1066")
public class CollapsibleIfStatementsCheck
extends PythonCheckTree {
    public static final String CHECK_KEY = "S1066";
    private static final String MESSAGE = "Merge this if statement with the enclosing one.";
    private Set<Tree> ignored = new HashSet<Tree>();

    public void scanFile(PythonVisitorContext visitorContext) {
        this.ignored.clear();
        super.scanFile(visitorContext);
    }

    public void visitIfStatement(PyIfStatementTree ifStatement) {
        List statements = ifStatement.body().statements();
        if (!ifStatement.elifBranches().isEmpty()) {
            if (ifStatement.elseBranch() == null) {
                this.ignored.addAll(ifStatement.elifBranches().subList(0, ifStatement.elifBranches().size() - 1));
            } else {
                this.ignored.addAll(ifStatement.elifBranches());
            }
        }
        if (!this.ignored.contains(ifStatement) && ifStatement.elseBranch() == null && ifStatement.elifBranches().isEmpty() && statements.size() == 1 && ((PyStatementTree)statements.get(0)).is(Tree.Kind.IF_STMT)) {
            PyIfStatementTree singleIfChild = (PyIfStatementTree)statements.get(0);
            if (singleIfChild.isElif() || singleIfChild.elseBranch() != null || !singleIfChild.elifBranches().isEmpty()) {
                return;
            }
            this.addIssue(singleIfChild.keyword(), MESSAGE).secondary((Tree)ifStatement, "enclosing");
        }
        super.visitIfStatement(ifStatement);
    }
}

