/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.impl.Parser;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheckAstNode;
import org.sonar.python.PythonConfiguration;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.parser.PythonParser;

@Rule(key="S125")
public class CommentedCodeCheck
extends PythonCheckAstNode {
    public static final String CHECK_KEY = "S125";
    public static final String MESSAGE = "Remove this commented out code.";
    private static final Parser<Grammar> parser = PythonParser.create((PythonConfiguration)new PythonConfiguration(StandardCharsets.UTF_8));

    public Set<AstNodeType> subscribedKinds() {
        return Collections.singleton(PythonTokenType.STRING);
    }

    public void visitNode(AstNode astNode) {
        if (CommentedCodeCheck.isMultilineComment(astNode)) {
            this.visitMultilineComment(astNode.getToken());
        }
    }

    public void visitToken(Token token) {
        List<List<Trivia>> groupedTrivias = CommentedCodeCheck.groupTrivias(token);
        for (List<Trivia> triviaGroup : groupedTrivias) {
            this.checkTriviaGroup(triviaGroup);
        }
    }

    private void visitMultilineComment(Token token) {
        String value = token.getValue();
        int startStringContent = value.endsWith("'''") ? value.indexOf("'''") + 3 : value.indexOf("\"\"\"") + 3;
        int endStringContent = value.length() - 3;
        String text = value.substring(startStringContent, endStringContent);
        if (!CommentedCodeCheck.isEmpty(text = text.trim()) && CommentedCodeCheck.isTextParsedAsCode(text)) {
            this.addIssue(token, MESSAGE);
        }
    }

    private static boolean isMultilineComment(AstNode node) {
        String str = node.getTokenValue();
        AstNode expressionStatement = node.getFirstAncestor((AstNodeType)PythonGrammar.EXPRESSION_STMT);
        return (str.endsWith("'''") || str.endsWith("\"\"\"")) && expressionStatement != null && expressionStatement.getNumberOfChildren() == 1;
    }

    private void checkTriviaGroup(List<Trivia> triviaGroup) {
        String text = CommentedCodeCheck.getTextForParsing(triviaGroup);
        if (CommentedCodeCheck.isEmpty(text)) {
            return;
        }
        if (CommentedCodeCheck.isTextParsedAsCode(text)) {
            this.addIssue(triviaGroup.get(0).getToken(), MESSAGE);
        }
    }

    private static String getTextForParsing(List<Trivia> triviaGroup) {
        StringBuilder commentTextSB = new StringBuilder();
        for (Trivia trivia : triviaGroup) {
            String value = trivia.getToken().getValue();
            while (value.startsWith("#") || value.startsWith(" #")) {
                value = value.substring(1);
            }
            if (value.startsWith(" ")) {
                value = value.substring(1);
            }
            if (triviaGroup.size() == 1) {
                value = value.trim();
            }
            if (CommentedCodeCheck.isOneWord(value)) continue;
            commentTextSB.append(value);
            commentTextSB.append("\n");
        }
        return commentTextSB.toString();
    }

    private static boolean isOneWord(String text) {
        return text.matches("\\s*[\\w/\\-]+\\s*#*\n*");
    }

    private static boolean isEmpty(String text) {
        return text.matches("\\s*");
    }

    private static boolean isTextParsedAsCode(String text) {
        try {
            AstNode astNode = parser.parse(text);
            List expressions = astNode.getDescendants(new AstNodeType[]{PythonGrammar.EXPRESSION_STMT});
            return astNode.getNumberOfChildren() > 1 && !CommentedCodeCheck.isSimpleExpression(expressions);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isSimpleExpression(List<AstNode> expressionStatements) {
        if (expressionStatements.size() != 1) {
            return false;
        }
        AstNode expressionStatement = expressionStatements.get(0);
        return expressionStatement.getNumberOfChildren() == 1 && expressionStatement.getFirstChild().is(new AstNodeType[]{PythonGrammar.TESTLIST_STAR_EXPR}) || expressionStatement.hasDirectChildren(new AstNodeType[]{PythonGrammar.ANNASSIGN});
    }

    private static List<List<Trivia>> groupTrivias(Token token) {
        LinkedList<List<Trivia>> result = new LinkedList<List<Trivia>>();
        List<Trivia> currentGroup = null;
        for (Trivia trivia : token.getTrivia()) {
            currentGroup = CommentedCodeCheck.handleOneLineComment(result, currentGroup, trivia);
        }
        if (currentGroup != null) {
            result.add(currentGroup);
        }
        return result;
    }

    private static List<Trivia> handleOneLineComment(List<List<Trivia>> result, @Nullable List<Trivia> currentGroup, Trivia trivia) {
        List<Trivia> newTriviaGroup = currentGroup;
        if (currentGroup == null) {
            newTriviaGroup = new LinkedList<Trivia>();
            newTriviaGroup.add(trivia);
        } else if (currentGroup.get(currentGroup.size() - 1).getToken().getLine() + 1 == trivia.getToken().getLine()) {
            newTriviaGroup.add(trivia);
        } else {
            result.add(currentGroup);
            newTriviaGroup = new LinkedList<Trivia>();
            newTriviaGroup.add(trivia);
        }
        return newTriviaGroup;
    }
}

