/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.text.MessageFormat;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonCheckAstNode;

@Rule(key="LineLength")
public class LineLengthCheck
extends PythonCheckAstNode {
    public static final String CHECK_KEY = "LineLength";
    private static final int DEFAULT_MAXIMUM_LINE_LENGTH = 120;
    private Token previousToken;
    @RuleProperty(key="maximumLineLength", defaultValue="120")
    public int maximumLineLength = 120;

    public int getMaximumLineLength() {
        return this.maximumLineLength;
    }

    public void visitFile(AstNode astNode) {
        this.previousToken = null;
    }

    public void leaveFile(AstNode astNode) {
        this.previousToken = null;
    }

    public void visitToken(Token token) {
        if (token.isGeneratedCode()) {
            return;
        }
        if (this.previousToken != null && this.previousToken.getLine() != token.getLine()) {
            String[] lines = this.previousToken.getValue().split("\r?\n|\r", -1);
            int length = this.previousToken.getColumn();
            for (String line : lines) {
                if ((length += line.length()) > this.getMaximumLineLength()) {
                    String message = MessageFormat.format("The line contains {0,number,integer} characters which is greater than {1,number,integer} authorized.", length, this.getMaximumLineLength());
                    this.addLineIssue(message, this.previousToken.getLine());
                }
                length = 0;
            }
        }
        this.previousToken = token;
    }
}

