/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.python.api.tree.PyArgListTree;
import org.sonar.python.api.tree.PyArgumentTree;
import org.sonar.python.api.tree.PyClassDefTree;
import org.sonar.python.api.tree.PyFunctionDefTree;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.checks.AbstractFunctionNameCheck;

@Rule(key="S100")
public class MethodNameCheck
extends AbstractFunctionNameCheck {
    public static final String CHECK_KEY = "S100";

    @Override
    public String typeName() {
        return "method";
    }

    @Override
    public boolean shouldCheckFunctionDeclaration(PyFunctionDefTree pyFunctionDefTree) {
        return pyFunctionDefTree.isMethodDefinition() && !MethodNameCheck.classHasInheritance(MethodNameCheck.getParentClassDef((Tree)pyFunctionDefTree));
    }

    private static PyClassDefTree getParentClassDef(Tree current) {
        while (current != null) {
            if (current.is(Tree.Kind.CLASSDEF)) {
                return (PyClassDefTree)current;
            }
            current = current.parent();
        }
        return null;
    }

    private static boolean classHasInheritance(PyClassDefTree classDef) {
        PyArgListTree argList = classDef.args();
        if (argList == null) {
            return false;
        }
        List arguments = argList.arguments();
        if (arguments.isEmpty()) {
            return false;
        }
        return arguments.size() != 1 || !"object".equals(((PyArgumentTree)arguments.get(0)).firstToken().getValue());
    }
}

