/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.api.tree.Tree;

@Rule(key="S1578")
public class ModuleNameCheck
extends PythonSubscriptionCheck {
    private static final String DEFAULT = "(([a-z_][a-z0-9_]*)|([A-Z][a-zA-Z0-9]+))$";
    private static final String MESSAGE = "Rename this module to match this regular expression: \"%s\".";
    @RuleProperty(key="format", defaultValue="(([a-z_][a-z0-9_]*)|([A-Z][a-zA-Z0-9]+))$")
    public String format = "(([a-z_][a-z0-9_]*)|([A-Z][a-zA-Z0-9]+))$";
    private Pattern pattern = null;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            String fileName = ctx.pythonFile().fileName();
            int dotIndex = fileName.lastIndexOf(46);
            if (dotIndex > 0) {
                String moduleName = fileName.substring(0, dotIndex);
                if (!this.pattern().matcher(moduleName).matches()) {
                    ctx.addFileIssue(String.format(MESSAGE, this.format));
                }
            }
        });
    }

    private Pattern pattern() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format);
        }
        return this.pattern;
    }
}

